// ============================================================================
//  $Id: TModuleSpecified.cc,v 1.1.1.1 2003/01/04 08:07:14 iwai Exp $
//  $Name:  $
// ============================================================================
#include "TModuleSpecified.hh"

TModuleSpecified::TModuleSpecified()
  : theModuleIndex( -1 ), theModuleID(), theGroupIDs()
{
  theGroupIDs.clear();
}

TModuleSpecified::TModuleSpecified( Tint index, const Tstring& id, const TstringList& groups )
  : theModuleIndex( index ), theModuleID( id ), theGroupIDs( groups )
{;}

TModuleSpecified::TModuleSpecified( const TModuleSpecified& right )
  : theModuleIndex( right.theModuleIndex ), 
    theModuleID( right.theModuleID ), theGroupIDs( right.theGroupIDs )
{;}

TModuleSpecified::~TModuleSpecified()
{;}

const TModuleSpecified& TModuleSpecified::operator=( const TModuleSpecified& right )
{
  theModuleIndex = right.theModuleIndex;
  theModuleID = right.theModuleID;
  theGroupIDs = right.theGroupIDs;
  return( *this );
}

Tbool TModuleSpecified::operator==( const TModuleSpecified& right ) const
{
  Tbool retval = Ttrue;
  retval &= ( theModuleIndex == right.theModuleIndex );
  retval &= ( theModuleID == right.theModuleID );
  retval &= ( theGroupIDs == right.theGroupIDs );
  return( retval );
}

Tbool TModuleSpecified::operator!=( const TModuleSpecified& right ) const
{
  Tbool retval = Tfalse;
  retval |= ( theModuleIndex != right.theModuleIndex );
  retval |= ( theModuleID != right.theModuleID );
  retval |= ( theGroupIDs != right.theGroupIDs );
  return( true );
}

Tbool TModuleSpecified::IsSameGroup( const TstringList& groups )
{
  for ( Tsize_t i = 0; i < theGroupIDs.size(); i ++ ) {
    for ( Tsize_t j = 0; j < groups.size(); j ++ ) {
      if ( theGroupIDs[ i ] == groups[ j ] ) {
	return( Ttrue );
      }
    }
  }
  return( Tfalse );
}

Tbool TModuleSpecified::IsSameGroup( const TModuleSpecified& spec )
{
  return( IsSameGroup( spec.GetGroupIDs() ) );
}

Tbool TModuleSpecified::IsSameGroup( const Tstring& group )
{
  TstringList groups;
  groups.push_back( group );
  return( IsSameGroup( groups ) );
}

Tostream& operator<<( Tostream& tos, const TModuleSpecified& right )
{
  tos << "Index: " << right.theModuleIndex << ", ";
  tos << "ID: " << right.theModuleID << ", ";
  tos << "Group: ";
  Tsize_t ngroups = right.theGroupIDs.size();
  for ( Tsize_t i = 0; i < ngroups; i ++ ) {
    tos << right.theGroupIDs[ i ];
    if ( i != ngroups - 1 ) {
      tos << ", ";
    }
  }
  tos << Tflush;
  return( tos );
}
