// ============================================================================
//  $Id: TVmeDaughterBoardMemoryModule.cc,v 1.1.1.1 2003/01/04 08:07:14 iwai Exp $
//  $Name:  $
// ============================================================================
#include "TVmeDaughterBoardMemoryModule.hh"
#include "TDataSegment.hh"
#include "TDataElement.hh"

TVmeDaughterBoardMemoryModule::TVmeDaughterBoardMemoryModule( Toff_t offset, Tint mapsize, Tint nsamples, Tint nch )
  : TVmeModule( nch, offset, mapsize, tA32D32 ),
    //theNumberOfSampling( nsamples / 2 ) // <- probrem
    theNumberOfSampling( nsamples )
{;}

TVmeDaughterBoardMemoryModule::TVmeDaughterBoardMemoryModule( const TVmeDaughterBoardMemoryModule& right )
  : TVmeModule( right ),
    theNumberOfSampling( right.theNumberOfSampling )
{;}

TVmeDaughterBoardMemoryModule::~TVmeDaughterBoardMemoryModule()
{;}

const TVmeDaughterBoardMemoryModule& TVmeDaughterBoardMemoryModule::operator=( const TVmeDaughterBoardMemoryModule& right )
{
  *( (TVmeModule*)this ) = *( (TVmeModule*)(&right) );
  theNumberOfSampling = right.theNumberOfSampling;
  return( *this );
}

Tbool TVmeDaughterBoardMemoryModule::operator==( const TVmeDaughterBoardMemoryModule& right ) const
{
  Tbool ret = Ttrue;
  ret &= ( *( (TVmeModule*)this ) == *( (TVmeModule*)(&right) ) );
  ret &= ( theNumberOfSampling == right.theNumberOfSampling );
  return( ret );
}

Tbool TVmeDaughterBoardMemoryModule::operator!=( const TVmeDaughterBoardMemoryModule& right ) const
{
  Tbool ret = Tfalse;
  ret |= ( *( (TVmeModule*)this ) != *( (TVmeModule*)(&right) ) );
  ret |= ( theNumberOfSampling != right.theNumberOfSampling );
  return( ret );
}

Tint TVmeDaughterBoardMemoryModule::Clear()
{
  Tlong* membase = (Tlong*)theBaseAddress;
  for ( Tint i = 0; i < theNumberOfSampling; i ++ )
    membase[ i ] = 0;
  return( theStatus = tStatusSuccess );
}

Tint TVmeDaughterBoardMemoryModule::Update()
{
  return( Clear() );
}

Tint TVmeDaughterBoardMemoryModule::Initialize()
{
  return( Clear() );
}

Tvoid TVmeDaughterBoardMemoryModule::FillData( TDataElement& element, Tint channel )
{
  if ( channel < 0 || channel >= theNumberOfChannels ) {
    Tcerr << "TVmeDaughterBoardMemoryModule::FillData: invalid ID " << channel << Tendl;
    theStatus = -EFAULT;
    element.FillData( &theStatus, tTypeInt, 1 );
  } else {
    // direct access, processing speed improve.
    Tlong* membase = (Tlong*)theBaseAddress;
    TUshort* databuf = new TUshort[ theNumberOfSampling ];
    for ( Tint i = 0; i < theNumberOfSampling; i ++ ) {
      databuf[ i ] = modifyData( (Tshort)( *membase & 0x0000ffff ) );
      membase ++;
    }
    element.FillData( databuf, tTypeUnsignedShort, theNumberOfSampling );
    delete [] databuf;
  }

  return;
}
