// ============================================================================
//  $Id: TVmeRpv130Module.hh,v 1.1.1.1 2003/01/04 08:07:14 iwai Exp $
//  $Name:  $
// ============================================================================
#ifndef __TVMERPV130MODULE_HH
#define __TVMERPV130MODULE_HH

#include "Tglobals.h"
#include "TVmeModule.hh"

class TDataSegment;
class TDataElement;
class TVmeDaughterBoardMemoryModule;

class TVmeRpv130Module
  : public TVmeModule
{

  private:
    enum {
      LATCH1 = 0x00,
      LATCH2 = 0x02,
      RSFF = 0x04,
      THROUGH = 0x06,
      PULSE = 0x08,
      LEVEL = 0x0a,
      CSR1 = 0x0c,
      CSR2 = 0x0e
    };

  public:
    enum {
      tReadoutWithLatch1,
      tReadoutWithLatch2,
      tReadoutWithRSFF,
      tReadoutWithThrough
    };

  private:
    Tint theReadoutMode;

  public:
    TVmeRpv130Module( Toff_t offset, Tint mapsize = 0x1000, Tint nch = 1 );
    TVmeRpv130Module( const TVmeRpv130Module& right );
    ~TVmeRpv130Module();

  public:
    Tint GetReadoutMode() const;
    Tvoid SetReadoutMode( Tint readmode );

  public:
    const TVmeRpv130Module& operator=( const TVmeRpv130Module& right );
    Tbool operator==( const TVmeRpv130Module& right ) const;
    Tbool operator!=( const TVmeRpv130Module& right ) const;

  public:
    Tint Clear();
    Tint Update();
    Tint Initialize();
    Tvoid FillData( TDataElement& element, Tint channel );

  public:
    Tvoid Pulse( Tint pattern );
    Tvoid Level( Tint pattern );
    Tvoid Enable();
    Tvoid Disable();
    TUshort Read();

};

inline Tint TVmeRpv130Module::GetReadoutMode() const
{
  return( theReadoutMode );
}

inline Tvoid TVmeRpv130Module::SetReadoutMode( Tint readmode )
{
  theReadoutMode = readmode;
  return;
}

#endif
