// ============================================================================
//  $Id: TReadoutBook.cc,v 1.1.1.1 2003/01/04 08:07:14 iwai Exp $
//  $Name:  $
// ============================================================================
#include "TReadoutBook.hh"
#include "TReadoutList.hh"
#include "TDataRecord.hh"

TReadoutBook::TReadoutBook()
  : theReadoutBook( 0 ), 
    theCapacity( 1 ), theNumberOfPages( 0 ), theIndex( 0 )
{
  allocate( theCapacity );
}

TReadoutBook::~TReadoutBook()
{
  free();
}

Tint TReadoutBook::AddReadoutList( TReadoutList* readoutlist )
{
  Tstring id = readoutlist -> GetID();
  if ( FindReadoutList( id ) != 0 ) {
    Tcerr << "TReadoutBook::AddReadoutList: already exist ReadoutList identified as " << id << "." << Tendl;
    return( theNumberOfPages );
  }

  if ( theNumberOfPages >= theCapacity )
    ResizeReadoutBook( theCapacity *= 2 );
  theReadoutBook[ theNumberOfPages ] = readoutlist;
  theNumberOfPages ++;
  theIndex = theNumberOfPages - 1;

  return( theNumberOfPages );
}

Tint TReadoutBook::RemoveReadoutList( Tint index )
{
  Tstring head = "TReadoutBook::RemoveReadoutList: ";
  if ( index < 0 || index >= theNumberOfPages ) {
    Tcerr << head << "invalid index " << index << "." << Tendl;
    return( theNumberOfPages );
  }
  theIndex = index;
  Tstring id = theReadoutBook[ theIndex ] -> GetID();
  delete theReadoutBook[ theIndex ];
  Tcout << head << "ReadoutList identified as " << id << " was deleted.";
  for ( Tint i = theIndex; i < theNumberOfPages; i ++ )
    theReadoutBook[ i ] = theReadoutBook[ i + 1 ];
  theNumberOfPages --;
  return( theNumberOfPages );
}

Tint TReadoutBook::RemoveReadoutList( const Tstring& id )
{
  for ( Tint index = 0; index < theNumberOfPages; index ++ ) {
    if ( theReadoutBook[ index ] -> GetID() == id ) {
      return( RemoveReadoutList( index ) );
    }
  }
  return( theNumberOfPages );
}

Tvoid TReadoutBook::ClearReadoutBook()
{
  Tstring head = "TReadoutBook::ClearReadoutBook: ";
  for ( Tint i = 0; i < theNumberOfPages; i ++ ) {
    if ( theReadoutBook[ i ] ) {
      Tstring id = theReadoutBook[ i ] -> GetID();
      delete theReadoutBook[ i ];
      Tcout << head << "ReadoutList identified as " << id << " was deleted.";
    }
  }
  theNumberOfPages = 0;
  theIndex = 0;
  return;
}

Tbool TReadoutBook::ResizeReadoutBook( Tint capacity )
{
  if ( theNumberOfPages >= capacity ) {
    Tcerr << "TReadoutBook::ResizeReadoutBook: invalid capacity " << capacity << "." << Tendl;
    return( Tfalse );
  }
  theCapacity = capacity;
  TReadoutList** newReadoutBook = new TReadoutList* [ theCapacity ];
  for ( Tint i = 0; i < theNumberOfPages; i ++ )
    newReadoutBook[ i ] = theReadoutBook[ i ];
  delete [] theReadoutBook;
  theReadoutBook = newReadoutBook;
  theIndex = theNumberOfPages - 1;
  return( Ttrue );
}

TReadoutList* TReadoutBook::NextReadoutList()
{
  if ( theIndex < 0 || theIndex >= theNumberOfPages )
    return( 0 );
  return( theReadoutBook[ theIndex ++ ] );
}

TReadoutList* TReadoutBook::FindReadoutList( const Tstring& id )
{
  Tint indexbuf = theIndex;
  theIndex = 0;
  TReadoutList* readoutlist = 0;
  while ( ( readoutlist = NextReadoutList() ) ) {
    if ( readoutlist -> GetID() == id ) {
      theIndex = indexbuf;
      return( readoutlist );
    }
  }
  theIndex = indexbuf;
  return( 0 );
}

TReadoutList* TReadoutBook::GetReadoutList( Tint index )
{
  if ( index < 0 || index >= theNumberOfPages ) {
    Tcerr << "TReadoutBook::GetReadoutList: invalid index " << index << "." << Tendl;
    return( 0 );
  }
  theIndex = index;
  return( theReadoutBook[ theIndex ] );
}

TReadoutList* TReadoutBook::GetReadoutList( const Tstring& id )
{
  return( FindReadoutList( id ) );
}

TReadoutList* TReadoutBook::GetReadoutList()
{
  return( GetReadoutList( theIndex ) );
}

TDataRecord TReadoutBook::ReadData( const Tstring& id )
{
  TReadoutList* readoutlist = FindReadoutList( id );
  TDataRecord record;
  if ( readoutlist ) {
    record = readoutlist -> ReadData();
  }
  return( record );
}

Tvoid TReadoutBook::free()
{
  Tstring head = "TReadoutBook::free: ";
  for ( Tint i = 0; i < theNumberOfPages; i ++ ) {
    if ( theReadoutBook[ i ] ) {
      Tstring id = theReadoutBook[ i ] -> GetID();
      delete theReadoutBook[ i ];
      Tcout << head << "ReadoutList identified as " << id << " was deleted." << Tendl;
    }
  }
  delete [] theReadoutBook;
  theCapacity = 0;
  theNumberOfPages = 0;
  theIndex = 0;
  return;
}

Tvoid TReadoutBook::allocate( Tint capacity )
{
  theCapacity = capacity;
  theReadoutBook = new TReadoutList* [ theCapacity ];
  return;
}
