// ============================================================================
//  $Id: TReadoutSegment.cc,v 1.1.1.1 2003/01/04 08:07:14 iwai Exp $
//  $Name:  $
// ============================================================================
#include "TReadoutSegment.hh"
#include "TDataSegment.hh"
#include "TModule.hh"

TReadoutSegment::TReadoutSegment(  const Tstring& id )
  : TReadoutIdentification( id ), TReadoutElementList(), theModule( 0 )
{;}

TReadoutSegment::TReadoutSegment( TModule* module, const Tstring& id )
  : TReadoutIdentification( id ), TReadoutElementList(), theModule( module )
{
  for ( Tint i = 0; i < module -> GetNumberOfChannels(); i ++ ) {
    push_back( TReadoutElement( module, itostr( i ) ) );
  }
}

TReadoutSegment::TReadoutSegment( TModule* module, const TstringList& elementid, const Tstring& id )
  : TReadoutIdentification( id ), TReadoutElementList(), theModule( module )
{
  Tsize_t nch = (Tsize_t)( module -> GetNumberOfChannels() );
  if ( nch > elementid.size() ) {
    for ( Tsize_t i = elementid.size(); i < nch; i ++ ) {
      ( (TstringList*)(&elementid) ) -> push_back( itostr( i ) );
    }
  }

  for ( Tsize_t i = 0; i < nch; i ++ ) {
    push_back( TReadoutElement( module, elementid[ i ] ) );
  }
}

TReadoutSegment::TReadoutSegment( TModule* module, const Tstring elementid[], const Tstring& id )
  : TReadoutIdentification( id ), TReadoutElementList(), theModule( module )
{
  Tint nch = module -> GetNumberOfChannels();
  // dangerous, no check, should be check string array here.
  for ( Tint i = 0; i < nch; i ++ ) {
    push_back( TReadoutElement( module, elementid[ i ] ) );
  }
}

TReadoutSegment::TReadoutSegment( const TReadoutSegment& right )
  : TReadoutIdentification( right ), TReadoutElementList( right ),
    theModule( right.theModule )
{;}

TReadoutSegment::~TReadoutSegment()
{;}

TDataSegment TReadoutSegment::ReadData()
{
  TDataSegment segment( theID );
  for ( Tsize_t i = 0; i < size(); i ++ ) {
    segment.push_back( ( (*this)[ i ] ).ReadData( i ) );
  }
  return( segment );
}

const TReadoutSegment& TReadoutSegment::operator=( const TReadoutSegment& right )
{
  *( (TReadoutIdentification*)this ) = *( (TReadoutIdentification*)(&right) );
  *( (TReadoutElementList*)this ) = *( (TReadoutElementList*)(&right) );
  *theModule = *(right.theModule);
  return( *this );
}

Tbool TReadoutSegment::operator==( const TReadoutSegment& right ) const
{
  Tbool ret = Ttrue;
  ret &= ( *( (TReadoutIdentification*)this ) == *( (TReadoutIdentification*)(&right) ) );
  ret &= ( *( (TReadoutElementList*)this ) == *( (TReadoutElementList*)(&right) ) );
  ret &= ( *theModule == *(right.theModule) );
  return( ret );
}

Tbool TReadoutSegment::operator!=( const TReadoutSegment& right ) const
{
  Tbool ret = Tfalse;
  ret |= ( *( (TReadoutIdentification*)this ) != *( (TReadoutIdentification*)(&right) ) );
  ret |= ( *( (TReadoutElementList*)this ) != *( (TReadoutElementList*)(&right) ) );
  ret |= ( *theModule != *(right.theModule) );
  return( ret );
}
