// ============================================================================
//  $Id: TRunInformationTable.cc,v 1.1.1.1 2003/01/04 08:07:14 iwai Exp $
//  $Name:  $
// ============================================================================
#include "TRunInformationTable.hh"
#include "TOutputHtmlFileStream.hh"

TRunInformationTable::TRunInformationTable()
  : theItemList(), theValueList()
{
  theItemList.clear();
  theValueList.clear();
}

TRunInformationTable::TRunInformationTable( const TstringList& itemlist )
  : theItemList( itemlist ), theValueList()
{
  theValueList.clear();
  Tstring empty = "";
  for ( Tsize_t i = 0; i < theItemList.size(); i ++ )
    theValueList.push_back( empty );
}

TRunInformationTable::TRunInformationTable( const TstringList& itemlist, const TstringList& valuelist )
  : theItemList( itemlist ), theValueList( valuelist )
{
  if ( theItemList.size() != theValueList.size() ) {
    Tstring head = "TRunInformationTable::TRunInformationTable: ";
    Tcerr << head << "size of table is mismatch." << Tendl;
    Clear();
    Tcerr << head << "table was cleared." << Tendl;
  }
}

TRunInformationTable::TRunInformationTable( const TRunInformationTable& right )
  : theItemList( right.theItemList ), theValueList( right.theValueList )
{;}

TRunInformationTable::~TRunInformationTable()
{;}

const TRunInformationTable& TRunInformationTable::operator=( const TRunInformationTable& right )
{
  theItemList = right.theItemList;
  theValueList = right.theValueList;
  return( *this );
}

Tbool TRunInformationTable::operator==( const TRunInformationTable& right ) const
{
  if ( theItemList == right.theItemList && theValueList == right.theValueList )
    return( Ttrue );
  else
    return( Tfalse );
}

Tbool TRunInformationTable::operator!=( const TRunInformationTable& right ) const
{
  if ( theItemList != right.theItemList || theValueList != right.theValueList )
    return( Ttrue );
  else
    return( Tfalse );
}

Tostream& operator<<( Tostream& tos, const TRunInformationTable& right )
{
  Tint nrow = right.GetNumberOfRows();
  for ( Tint i = 0; i < nrow; i ++ ) {
    tos << right.theItemList[ i ] << Tcolon << Tspace << right.theValueList[ i ];
    if ( i != nrow - 1 )
      tos << Tendl;
  }
  return( tos );
}

TOutputHtmlFileStream& operator<<( TOutputHtmlFileStream& tohf, const TRunInformationTable& right )
{
  tohf.SetInformationTable( right );
  return( tohf.MakeTable() );
}


Tint TRunInformationTable::GetNumberOfRows() const
{
  return( (Tint)theItemList.size() );
}

Tvoid TRunInformationTable::AddRow( const Tstring& item, const Tstring& value )
{
  if ( HasItem( item ) ) {
    Tstring head = "TRunInformationTable::AddRow: ";
    Tcerr << head << item << " already exist." << Tendl;
    return;
  }
  theItemList.push_back( item );
  theValueList.push_back( value );
  return;
}

Tvoid TRunInformationTable::SetRow( const Tstring& item, const Tstring& value )
{
  if ( HasItem( item ) ) {
    Tint pos = FindItem( item );
    theItemList[ pos ] = item;
    theValueList[ pos ] = value;
  } else {
    Tstring head = "TRunInformationTable::SetRow: ";
    Tcerr << head << item << " doesn't exist." << Tendl;
  }
  return;
}

Tstring TRunInformationTable::GetValue( const Tstring& item ) const
{
  Tstring retval = "";
  if ( HasItem( item ) ) {
    Tint pos = FindItem( item );
    retval = theValueList[ pos ];
  } else {
    Tstring head = "TRunInformationTable::GetValue: ";
    Tcerr << head << item << " doesn't exist." << Tendl;
  }
  return( retval );
}

Tstring TRunInformationTable::GetValue( Tint nrow ) const
{
  Tstring retval = "";
  if ( nrow >= 0 && nrow < (Tint)theValueList.size() )
    retval = theValueList[ nrow ];
  return( retval );
}

Tstring TRunInformationTable::GetItem( const Tstring& value ) const
{
  Tstring retitem = "";
  Tint pos = FindValue( value );
  if ( pos >= 0 && pos < (Tint)theItemList.size() ) {
    retitem = theItemList[ pos ];
  } else {
    Tstring head = "TRunInformationTable::GetItem: ";
    Tcerr << head << value << " doesn't exist." << Tendl;
  }
  return( retitem );
}

Tstring TRunInformationTable::GetItem( Tint nrow ) const
{
  Tstring retitem = "";
  if ( nrow >= 0 && nrow < (Tint)theItemList.size() )
    retitem = theItemList[ nrow ];
  return( retitem );
}

Tint TRunInformationTable::FindItem( const Tstring& item ) const
{
  for ( Tint i = 0; i < (Tint)theItemList.size(); i ++ ) {
    if ( theItemList[ i ] == item )
      return( i );
  }
  return( tNotFound );
}

Tint TRunInformationTable::FindValue( const Tstring& value ) const
{
  for ( Tint i = 0; i < (Tint)theValueList.size(); i ++ ) {
    if ( theValueList[ i ] == value )
      return( i );
  }
  return( tNotFound );
}

Tbool TRunInformationTable::HasItem( const Tstring& item ) const
{
  if ( FindItem( item ) == tNotFound )
    return( Tfalse );
  return( Ttrue );
}

Tvoid TRunInformationTable::Remove( const Tstring& item )
{
  if ( HasItem( item ) ) {
    Tint pos = FindItem( item );
    theItemList.erase( theItemList.begin() + pos );
    theValueList.erase( theValueList.begin() + pos );
  } else {
    Tstring head = "TRunInformationTable::Remove: ";
    Tcerr << head << item << " doesn't exist." << Tendl;
  }
  return;
}

Tvoid TRunInformationTable::Clear()
{
  theItemList.clear();
  theValueList.clear();
  return;
}
