// ============================================================================
//  $Id: TSystemTimer.hh,v 1.1.1.1 2003/01/04 08:07:14 iwai Exp $
//  $Name:  $
// ============================================================================
#ifndef __TSYSTEMTIMER_HH
#define __TSYSTEMTIMER_HH

#include "Tglobals.h"

class TSystemTimer
{

  private:
    Tbool theValidTimes;
    Tclock_t theBeginOfRealTime;
    Tclock_t theEndOfRealTime;
    struct tms theBeginOfTimes;
    struct tms theEndOfTimes;

  public:
    TSystemTimer();
    TSystemTimer( const TSystemTimer& right );
    ~TSystemTimer();

  public:
    Tclock_t GetBeginOfRealTime() const;
    Tclock_t GetEndOfRealTime() const;
    const struct tms& GetBeginOfTimes() const;
    const struct tms& GetEndOfTimes() const;
    struct tms& GetBeginOfTimes();
    struct tms& GetEndOfTimes();

  public:
    const TSystemTimer& operator=( const TSystemTimer& right );
    friend Tostream& operator<<( Tostream& tos, const TSystemTimer& right );

  public:
    Tvoid Start();
    Tvoid Pause();
    Tvoid Restart();
    Tvoid Stop();
    Tvoid Reset();
    Tvoid Continue();

  public:
    Tbool IsValid() const;
    Tdouble GetRealElapsedTime() const;
    Tdouble GetSystemElapsedTime() const;
    Tdouble GetUserElapsedTime() const;
    Tdouble GetSystemElapsedTimeOfChildren() const;
    Tdouble GetUserElapsedTimeOfChildren() const;

};

inline Tbool TSystemTimer::IsValid() const
{
  return( theValidTimes );
}

inline Tclock_t TSystemTimer::GetBeginOfRealTime() const
{
  return( theBeginOfRealTime );
}

inline Tclock_t TSystemTimer::GetEndOfRealTime() const
{
  return( theEndOfRealTime );
}

inline const struct tms& TSystemTimer::GetBeginOfTimes() const
{
  return( theBeginOfTimes );
}

inline const struct tms& TSystemTimer::GetEndOfTimes() const
{
  return( theEndOfTimes );
}

inline struct tms& TSystemTimer::GetBeginOfTimes()
{
  return( theBeginOfTimes );
}

inline struct tms& TSystemTimer::GetEndOfTimes()
{
  return( theEndOfTimes );
}

#endif
