// ============================================================================
//  $Id: Tglobals.h,v 1.2 2003/01/20 11:14:18 iwai Exp $
//  $Name:  $
// ============================================================================
#ifndef __TGLOBALS_H
#define __TGLOBALS_H

#include <pthread.h>

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include <X11/cursorfont.h>
#include <X11/keysym.h>
#include <X11/xpm.h>

#include <stdio.h>
#include <string.h>
#include <fstream>
#include <stdlib.h>
#include <time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/un.h>
#include <fcntl.h>
#include <sys/time.h>
#include <sys/times.h>
#include <errno.h>
#include <math.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <signal.h>
#include <sys/ioctl.h>
#include <sys/ipc.h>
#include <sys/sem.h>
#include <sys/shm.h>
#include <sys/wait.h>
#include <termios.h>
#include <sys/mman.h>
#include <term.h>
#include <ncurses.h>
#include <unistd.h>

#ifdef __CCD_ROOT_USE
#include <TROOT.h>
#include <TSystem.h>
#include <TApplication.h> 
#include <TStyle.h>
#include <TGraph.h>
#include <TH1.h>
#include <TH2.h>
#include <TCanvas.h>
#include <TNtuple.h>
#include <TFile.h>
#include <TPad.h>
#endif

#ifdef __CCD_ZLIB_USE
#include <zlib.h>
#endif

#include <linux/param.h>

#ifndef __USE_BSD
typedef __caddr_t caddr_t;
#endif

#if defined(__GNU_LIBRARY__) && !defined(_SEM_SEMUN_UNDEFINED)
// see <sys/sem.h>
#else
// if defer to X/OPEN design
union semun {
  int val;                    // value for SETVAL
  struct semid_ds* buf;       // buffer for IPC_STAT, IPC_SET
  unsigned short int* array;  // array for GETALL, SETALL
  struct seminfo* __buf;      // buffer for IPC_INFO
};
#endif

#include "Ttypes.h"

extern Tchar** environ;

inline Tstring itostr( Tint i )
{
  static const Tsize_t maxlen = 256;
  Tchar* s = new Tchar[ maxlen ];
  snprintf( s, maxlen, "%d", i );
  Tstring retstr = s;
  delete [] s;
  return( retstr );
}

inline Tstring ltostr( Tlong l )
{
  static const Tsize_t maxlen = 256;
  Tchar* s = new Tchar[ maxlen ];
  snprintf( s, maxlen, "%d", (Tint)l );
  Tstring retstr = s;
  delete [] s;
  return( retstr );
}

inline Tstring ultostr( TUlong ul )
{
  static const Tsize_t maxlen = 256;
  Tchar* s = new Tchar[ maxlen ];
  snprintf( s, maxlen, "%u", (TUint)ul );
  Tstring retstr = s;
  delete [] s;
  return( retstr );
}

inline Tstring dtostr( Tdouble d )
{
  static const Tsize_t maxlen = 256;
  Tchar* s = new Tchar[ maxlen ];
  snprintf( s, maxlen, "%f", d );
  Tstring retstr = s;
  delete [] s;
  return( retstr );
}

inline TDataRecord testrecord( Tint val )
{
  TDataRecord record( "This is a Data Record." );
  TDataSection section( "This is Data Section." );
  TDataSegment segment0( "This is a Data Segement identified 0." );
  TDataSegment segment1( "This is a Data Segement identified 1." );
  TDataSegment segment2( "This is a Data Segement identified 2." );

  Ttime_t time_now;
  Tint pasttime = (Tint)time( &time_now );
  struct tm* tm_now = localtime( &time_now );
  Tsize_t length = 64;
  Tchar* tmp = new Tchar[ length ];
  strftime( tmp, length,"%Y/%m/%d %H:%M:%S", tm_now );
  string tstr = tmp;
  delete [] tmp;
  const Tint nstrdata = 2;
  string strdata[ nstrdata ] = { 
    "ABCDEF ABCDEF ABCDEF ABCDEF END", 
    "abcefghijklmnopqrstuvwxyz abcefghijklmnopqrstuvwxyz end"
  };
  const Tint ndata = 1000;
  TUshort array[ ndata ];
  for ( TUshort i = 0; i < ndata; i ++ ) {
    array[ i ] = i + i;
  }
  
  segment0.push_back( TDataElement( &pasttime, tTypeInt, "This is a integer data(TIME).", 1 ) );
  segment0.push_back( TDataElement( &tstr, tTypeString, "This is a string data(TIME).", 1 ) );
  segment0.push_back( TDataElement( strdata, tTypeString, "This is a string array.", nstrdata ) );
  segment0.push_back( TDataElement( array, tTypeUnsignedShort, "This is unsigned short data array.", ndata ) );

  for ( Tint i = 0; i < 8; i ++ ) {
    Tint data = i + i * i + 0x1234 * val;
    segment1.push_back( TDataElement( &data, tTypeInt, itostr( i ) ) );
  }

  for ( Tdouble i = 0.0; i < 16.0; i ++ ) {
    Tdouble data = sin( i ) / i;
    segment2.push_back( TDataElement( &data, tTypeDouble, dtostr( i ) ) );
  }

  section.push_back( segment0 );
  section.push_back( segment1 );
  section.push_back( segment2 );
  record.push_back( section );

  return( record );
}

#endif
