// ============================================================================
//  $Id: BtEventViewCommand.cc,v 1.1.1.1 2003/01/04 08:07:14 iwai Exp $
//  $Name:  $
// ============================================================================
#include "TRunManager.hh"
#include "TUserInterface.hh"
#include "TOutputObjectFile.hh"

#include "BtEventViewCommand.hh"
#include "BtRunAction.hh"

static const Tstring _name = "/local/eventview";
static const Tstring _desc = "view histogram(ADC/Scaler).";

BtEventViewCommand::BtEventViewCommand()
  : TCommand( _name, _desc )
{;}

BtEventViewCommand::~BtEventViewCommand()
{;}

Tvoid BtEventViewCommand::Execute( const TstringList& arguments )
{
  TUserInterface* ui = theRunManager -> GetUserInterface();
  BtRunAction* action = (BtRunAction*)( theRunManager -> GetRunAction() );
  Tstring filename = action -> GetOutputFile() -> GetFileName();
  Tstring com = "/system/shell";
  TstringList args;
  args.push_back( "./../../bin/eventview" );
  args.push_back( filename );
  args.push_back( "&" );

  ui -> ExecuteCommand( com, args );

  return;
}
