// ============================================================================
//  $Id: eventview.cc,v 1.1.1.1 2003/01/04 08:07:14 iwai Exp $
//  $Name:  $
// ============================================================================
#include <TROOT.h>
#include <TSystem.h>
#include <TApplication.h> 
#include <TStyle.h>
#include <TGraph.h>
#include <TH1.h>
#include <TH2.h>
#include <TCanvas.h>
#include <TNtuple.h>
#include <TFile.h>
#include <TPad.h>

#include "TDataRecord.hh"
#include "TDataSection.hh"
#include "TDataSegment.hh"
#include "TDataElement.hh"
#include "TInputObjectFile.hh"

int main( int argc, char** argv, char** envv )
{
  if ( argc != 2 ) {
    Tcerr << "usage: " << argv[ 0 ] << Tspace << "<filename>" << Tendl;
    return( -1 );
  }

  TApplication* theApp = new TApplication( "root-analyser", 0, 0 );
  gROOT -> Reset( 0 );

  Tstring filename = argv[ 1 ];
  TInputObjectFile ifile = TInputObjectFile( filename );
  TDataRecord record;

  TCanvas adccanvas( "adc", "ADC #0" );
  gPad -> SetGrid();
  gStyle -> SetOptStat( 1111111 );

  TCanvas scalercanvas( "scaler", "SCALER #0-7" );
  gPad -> SetGrid();
  gStyle -> SetOptStat( 1111111 );

  TH1D adchist( "adc1Dhisto", "ADC #0", 400, 0, 4095 );
  TH1D scalerhist( "scaler1Dhisto", "SCALER #0-7", 8, 0, 8 );

  Tstring adcidset[ 3 ] = { "EVENT", "ADC", "0" };
  Tstring scaleridset[ 2 ] = { "EVENT", "SCALER" };

  while ( 1 ) {

    Tint datasize = ifile >> record;
    if ( datasize == 0 ) {
      ifile.SetOffset( ifile.GetTotalDataSize(), SEEK_SET );
      sleep( 1 );
      continue;
    }
    Tstring recid = record.GetID();


    if ( recid == "RUN BEGIN" ) {
      continue;
    } else if ( recid == "RUN END" ) {
      break;
    } else if ( recid == "CSI EVENT" ) {

      TDataElement element;
      record.FindDataElement( adcidset, element );
      TUint count = *( element.GetUnsignedIntData() );
      adccanvas.cd();
      adchist.Fill( (Tdouble)count );
      adchist.Draw();
      adccanvas.Modified();
      adccanvas.Update();

    } else if ( recid == "SCALER EVENT" ) {

      TDataSegment segment;
      record.FindDataSegment( scaleridset, segment );
      for ( Tint i = 0; i < 8; i ++ ) {
	TDataElement element = segment[ i ];
	TUint count = *( element.GetUnsignedIntData() );
	scalerhist.Fill( (Tdouble)i, (Tdouble)count );
      }
      scalercanvas.cd();
      scalerhist.Draw();
      scalercanvas.Modified();
      scalercanvas.Update();

    } else {
      break;
    }

    gSystem -> ProcessEvents();

  }

  theApp -> Run();

  return( 0 );
}
