// ============================================================================
//  $Id: DummyRunSummary.hh,v 1.1.1.1 2003/01/04 08:07:14 iwai Exp $
//  $Name:  $
// ============================================================================
#ifndef __DUMMYRUNSUMMARY_HH
#define __DUMMYRUNSUMMARY_HH

#include "Tglobals.h"
#include "TRunInformationTable.hh"

class DummyRunSummary
{

  private:
    Tint theRunID;
    Tstring theRecordName;
    Tint theRecordSize;
    Tint theNumberOfEvents;
    TRunInformationTable theRunInformationTable;
    Tstring theRunBeginTime;
    Tstring theRunEndTime;

  public:
    DummyRunSummary();
    ~DummyRunSummary();

  public:
    TRunInformationTable GenerateRunSummaryTable() const;
    Tvoid Initialize();

  public:
    Tint GetRunID() const;
    const Tstring& GetRecordName() const;
    Tint GetRecordSize() const;
    Tint GetNumberOfEvents() const;
    const TRunInformationTable& GetRunInformationTable() const;
    const Tstring& GetRunBeginTime() const;
    const Tstring& GetRunEndTime() const;
    Tvoid SetRunID( Tint runid );
    Tvoid SetRecordName( const Tstring& recname );
    Tvoid SetRecordSize( Tint size );
    Tvoid SetNumberOfEvents( Tint nevents );
    Tvoid SetRunInformationTable( const TRunInformationTable& table );
    Tvoid SetRunBeginTime( const Tstring& time );
    Tvoid SetRunEndTime( const Tstring& time );

};

inline Tint DummyRunSummary::GetRunID() const
{
  return( theRunID );
}

inline const Tstring& DummyRunSummary::GetRecordName() const
{
  return( theRecordName );
}

inline Tint DummyRunSummary::GetRecordSize() const
{
  return( theRecordSize );
}

inline Tint DummyRunSummary::GetNumberOfEvents() const
{
  return( theNumberOfEvents );
}

inline const TRunInformationTable& DummyRunSummary::GetRunInformationTable() const
{
  return( theRunInformationTable );
}

inline const Tstring& DummyRunSummary::GetRunBeginTime() const
{
  return( theRunBeginTime );
}

inline const Tstring& DummyRunSummary::GetRunEndTime() const
{
  return( theRunEndTime );
}

inline Tvoid DummyRunSummary::SetRunID( Tint runid )
{
  theRunID = runid;
  return;
}

inline Tvoid DummyRunSummary::SetRecordName( const Tstring& recname )
{
  theRecordName = recname;
  return;
}

inline Tvoid DummyRunSummary::SetRecordSize( Tint size )
{
  theRecordSize = size;
  return;
}

inline Tvoid DummyRunSummary::SetNumberOfEvents( Tint nevents )
{
  theNumberOfEvents = nevents;
  return;
}

inline Tvoid DummyRunSummary::SetRunInformationTable( const TRunInformationTable& table )
{
  theRunInformationTable = table;
  return;
}

inline Tvoid DummyRunSummary::SetRunBeginTime( const Tstring& time )
{
  theRunBeginTime = time;
  return;
}

inline Tvoid DummyRunSummary::SetRunEndTime( const Tstring& time )
{
  theRunEndTime = time;
  return;
}

#endif
