// ============================================================================
//  $Id: adcview.cc,v 1.1.1.1 2003/01/04 08:07:14 iwai Exp $
//  $Name:  $
// ============================================================================
#include <TROOT.h>
#include <TSystem.h>
#include <TApplication.h> 
#include <TStyle.h>
#include <TGraph.h>
#include <TH1.h>
#include <TH2.h>
#include <TCanvas.h>
#include <TNtuple.h>
#include <TFile.h>
#include <TPad.h>

#include "TDataRecord.hh"
#include "TDataSection.hh"
#include "TDataSegment.hh"
#include "TDataElement.hh"
#include "TInputObjectFile.hh"

int main( int argc, char** argv, char** envv )
{
  if ( argc != 2 ) {
    Tcerr << "usage: " << argv[ 0 ] << Tspace << "<filename>" << Tendl;
    return( -1 );
  }

  TApplication* theApp = new TApplication( "root-analyser", 0, 0 );
  gROOT -> Reset( 0 );


  Tstring filename = argv[ 1 ];
  TInputObjectFile ifile = TInputObjectFile( filename );
  TDataRecord record;

  TCanvas canvas( "adc", "ADC VIEWER", 800, 800 );
  gPad -> SetGrid();
  gStyle -> SetOptStat( 1111111 );
  canvas.Divide( 4, 4 );

  TH1D adchist[ 16 ];
  for ( Tint i = 0; i < 16; i ++ ) {
    Tstring name = "adc" + itostr( i );
    Tstring title = "ADC #" + itostr( i );
    adchist[ i ] = TH1D( name.c_str(), title.c_str(), 100, 0, 4095 );
  }

  Tstring idset[ 3 ] = { "Event Data", "ADC" };

  while ( 1 ) {

    Tint datasize = ifile >> record;
    if ( datasize == 0 ) {
      ifile.SetOffset( ifile.GetTotalDataSize(), SEEK_SET );
      sleep( 1 );
      continue;
    }

    Tstring recid = record.GetID();

    if ( recid == "RUN BEGIN" ) {
      continue;
    } else if ( recid == "RUN END" ) {
      break;
    } else if ( recid == "EVENT" ) {


      TDataSegment segment;
      record.FindDataSegment( idset, segment );

      for ( Tint i = 0; i < 16; i ++ ) {
	TDataElement element = segment[ i ];
	Tint count = *( element.GetIntData() );
	adchist[ i ].Fill( (Tdouble)count );
	canvas.cd( i + 1 );
	adchist[ i ].Draw();
      }

      canvas.Modified();
      canvas.Update();      

    } else {
      break;
    }

    gSystem -> ProcessEvents();

  }

  theApp -> Run();

  return( 0 );
}
