// ============================================================================
//  $Id: StCrateDefinition.cc,v 1.1.1.1 2003/01/04 08:07:14 iwai Exp $
//  $Name:  $
// ============================================================================
#include "TCrate.hh"
#include "TSoftwareScalerModule.hh"
#include "TSoftwareClockModule.hh"
#include "TSoftwareRunInformationModule.hh"
#include "TRunInformationTable.hh"
#include "TVmeMpx201aModule.hh"
#include "TVmeRpv130Module.hh"
#include "TVmeDaughterBoardMemoryModule.hh"
#include "TEnvironmentVariableTable.hh"
#include "TRunManager.hh"

#include "StCrateDefinition.hh"

StCrateDefinition::StCrateDefinition()
  : TCrateDefinition()
{;}

StCrateDefinition::~StCrateDefinition()
{;}

TCrate* StCrateDefinition::Define()
{
  TstringList itemlist;
  itemlist.clear();
  itemlist.push_back( "OPERATOR" );
  itemlist.push_back( "RUN TYPE" );
  itemlist.push_back( "DEVICE ID" );
  itemlist.push_back( "TEMPERATURE[C]" );
  itemlist.push_back( "RUN BEGIN RESISTANCE[ohm]" );
  itemlist.push_back( "RUN END RESISTANCE[ohm]" );
  itemlist.push_back( "RUN BEGIN PRESSURE[Pa]" );
  itemlist.push_back( "RUN END PRESSURE[Pa]" );
  itemlist.push_back( "CYCLE[sec]" );
  itemlist.push_back( "IRRADIATION TIME[sec]" );
  itemlist.push_back( "OTHER CONDITION" );
  itemlist.push_back( "COMMENT" );
  TstringList valuelist;
  valuelist.clear();
  for ( Tsize_t i = 0; i < itemlist.size(); i ++ ) {
    valuelist.push_back( "***" );
  }
  TRunInformationTable runinfotable = TRunInformationTable( itemlist, valuelist );

  TCrate* crate = new TCrate();
  TstringList groups;

  // VME module
  const TEnvironmentVariableTable& envtable = 
    TRunManager::GetRunManager() -> GetEnvironmentVariableTable();

  Tint mpxoffset = envtable.GetIntegerValue( "ST_MPX201A_OFFSET" );
  Tint samplerate = envtable.GetIntegerValue( "ST_MPX201A_SAMPLING" );
  Tint nblock = envtable.GetIntegerValue( "ST_MPX201A_BLOCK" );
  Tint memoffset = envtable.GetIntegerValue( "ST_MPX201A_DAUGHTER" );
  Tint rpvoffset = envtable.GetIntegerValue( "ST_RPV130_OFFSET" );

  TVmeMpx201aModule* mpx201a = new TVmeMpx201aModule( mpxoffset );
  mpx201a -> SetupCCDmeasurement( samplerate, nblock, memoffset );
  TVmeDaughterBoardMemoryModule* daughter
    = new TVmeDaughterBoardMemoryModule( mpx201a );
  TVmeRpv130Module* rpv130 = new TVmeRpv130Module( rpvoffset );

  groups.clear();
  groups.push_back( "run begin" );
  groups.push_back( "event" );
  crate -> InstallModule( mpx201a, "mpx201a", groups );
  crate -> InstallModule( daughter, "daughter", groups );
  crate -> InstallModule( rpv130, "rpv130", groups );


  // software module
  TSoftwareRunInformationModule* runinfo
    = new TSoftwareRunInformationModule( runinfotable );
  crate -> InstallModule( runinfo, "runinfo" );
  TRunManager::GetRunManager() -> SetRunInformationModule( runinfo );

  TSoftwareClockModule* clock = new TSoftwareClockModule( 1 );
  groups.clear();
  groups.push_back( "run begin" );
  crate -> InstallModule( clock, "clock", groups );

  TSoftwareScalerModule* runid = new TSoftwareScalerModule( 1 );
  groups.clear();
  groups.push_back( "run begin" );
  crate -> InstallModule( runid, "runid", groups );

  TSoftwareScalerModule* evtid = new TSoftwareScalerModule( 1 );
  groups.clear();
  groups.push_back( "run begin" );
  groups.push_back( "event" );
  crate -> InstallModule( evtid, "evtid", groups );

  return( crate );
}
