// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#include "StMap.hh"

// 264276(եƥΰ256x256)
// 576ԥ뤴Ȥ˥ƥ륷եȤȯ
static const Tstring _rcfile = "setenvrc";

StMap::StMap( const Tstring& filename )
  : theEnvironmentVariableTable( _rcfile ),
    theNumberOfHorizontalPixels( theEnvironmentVariableTable.GetIntegerValue( "ST_HPIXEL" ) ),
    theNumberOfVerticalPixels( theEnvironmentVariableTable.GetIntegerValue( "ST_VPIXEL" ) ),
    theRateOfVerticalShift( theEnvironmentVariableTable.GetIntegerValue( "ST_VSHIFT_CYCLE" ) ),
    theNumberOfHorizontalOverClockPixels( theEnvironmentVariableTable.GetIntegerValue( "ST_HOC_PIXEL" ) ),
    theInputFileName( filename ),
    theHOCbuffer( 0.0 ),
    theMap( theNumberOfVerticalPixels, theNumberOfHorizontalPixels, 0 )
{;}

StMap::~StMap()
{;}

Tpixel_t StMap::IsThisPixel( Tint dataid ) const
{
  if ( dataid > theRateOfVerticalShift * theNumberOfVerticalPixels + theNumberOfHorizontalOverClockPixels ) {
    return( tIgnore );
  }

  Tint colid = dataid % theRateOfVerticalShift;
  if ( colid < theNumberOfHorizontalPixels ) {
    return( tEffective );
  } else if ( colid < theNumberOfHorizontalPixels + theNumberOfHorizontalOverClockPixels - 1 ) {
    return( tHoc );
  } else if ( colid == theNumberOfHorizontalPixels + theNumberOfHorizontalOverClockPixels - 1 ) {
    return( tEndOfHoc );
  } else {
    return( tIgnore );
  }
}

Tvoid StMap::FillMap( Tshort* data, Tint ndata )
{
  for ( Tint i = 0; i < ndata; i ++ ) {
    Tpixel_t pt = IsThisPixel( i );
    if ( pt == tIgnore ) {
      continue;
    } else if ( pt == tEffective ) {
      Tint colid = i % theRateOfVerticalShift;
      Tint rowid = i / theRateOfVerticalShift;
      theMap[ rowid ][ colid ] = (Tdouble)data[ i ];
    } else if ( pt == tHoc ) {
      theHOCbuffer += data[ i ];
    } else if ( pt == tEndOfHoc ) {
      theHOCbuffer += data[ i ];
      Tdouble ave = theHOCbuffer / theNumberOfHorizontalOverClockPixels;
      Tint rowid = i / theRateOfVerticalShift;
      for ( Tint col = 0; col < theNumberOfHorizontalPixels; col ++ ) {
	theMap[ rowid ][ col ] -= ave;
      }
      theHOCbuffer = 0.0;
    }
  }
  return;
}
