// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#ifndef __STOFFLINEDARKAVERAGEMAP_HH
#define __STOFFLINEDARKAVERAGEMAP_HH

#include "Tglobals.h"
#include "StMap.hh"

class StOfflineDarkAverageMap
  : public StMap
{

  private:
    TDataMultiplicity theCounterMap;
    Tint theNumberOfFrames;

  public:
    StOfflineDarkAverageMap( const Tstring& filename );
    ~StOfflineDarkAverageMap();

  public:
    Tvoid FillMap( Tshort* data, Tint ndata );
    const TDataMultiplicity& GetCounterMap() const;
    TDataMultiplicity& GetCounterMap();
    Tint GetNumberOfFrames() const;

};

inline const TDataMultiplicity& StOfflineDarkAverageMap::GetCounterMap() const
{
  return( theCounterMap );
}

inline TDataMultiplicity& StOfflineDarkAverageMap::GetCounterMap()
{
  return( theCounterMap );
}

inline Tint StOfflineDarkAverageMap::GetNumberOfFrames() const
{
  return( theNumberOfFrames );
}

#endif
