// ============================================================================
//  $Id: StPureEventViewCommand.cc,v 1.1.1.1 2003/01/04 08:07:14 iwai Exp $
//  $Name:  $
// ============================================================================
#include "TRunManager.hh"
#include "TUserInterface.hh"
#include "TOutputObjectFile.hh"

#include "StPureEventViewCommand.hh"
#include "StRunAction.hh"

static const Tstring _name = "/local/pureeventview";
static const Tstring _desc = "view histogram.";

StPureEventViewCommand::StPureEventViewCommand()
  : TCommand( _name, _desc )
{;}

StPureEventViewCommand::~StPureEventViewCommand()
{;}

Tvoid StPureEventViewCommand::Execute( const TstringList& arguments )
{
  TUserInterface* ui = theRunManager -> GetUserInterface();
  StRunAction* action = (StRunAction*)( theRunManager -> GetRunAction() );
  Tstring runid = theRunManager -> GetRun().GetRunIDofString();
  Tstring title = Twquote + "pure data, run " + runid + Twquote;

  Tstring filename = action -> GetOutputFile() -> GetFileName();
  Tstring com = "/system/shell";
  TstringList args;
  args.push_back( "./../../bin/pureeventview" );
  args.push_back( filename );
  args.push_back( title );
  args.push_back( "&" );

  ui -> ExecuteCommand( com, args );

  return;
}
