// ============================================================================
//  $Id: StReadoutBookDefinition.cc,v 1.1.1.1 2003/01/04 08:07:14 iwai Exp $
//  $Name:  $
// ============================================================================
#include "TReadoutList.hh"
#include "TReadoutSection.hh"
#include "TReadoutSegment.hh"
#include "TCrate.hh"
#include "TReadoutBook.hh"

#include "StReadoutBookDefinition.hh"

StReadoutBookDefinition::StReadoutBookDefinition()
  : TReadoutBookDefinition()
{;}

StReadoutBookDefinition::~StReadoutBookDefinition()
{;}

TReadoutBook* StReadoutBookDefinition::Define()
{
  TReadoutBook* book = new TReadoutBook();

  // define run begin record
  TReadoutList* runbegin = new TReadoutList( "RUN BEGIN" );
  TReadoutSection sec0( "INFO" );
  TReadoutSegment runid( theCrate -> GetModule( "runid" ), "RUN ID" );
  TReadoutSegment runinfo( theCrate -> GetModule( "runinfo" ), "RUN INFO" );
  TReadoutSegment clock( theCrate -> GetModule( "clock" ), "CLOCK" );
  sec0.push_back( runid );
  sec0.push_back( runinfo );
  sec0.push_back( clock );
  runbegin -> push_back( sec0 );



  // define run end record
  TReadoutList* runend = new TReadoutList( "RUN END" );
  TReadoutSection sec1( "INFO" );
  sec1.push_back( runinfo );
  sec1.push_back( clock );
  runend -> push_back( sec1 );



  // define event record
  TReadoutList* event = new TReadoutList( "EVENT" );
  TReadoutSection sec2( "EVENT" );
  TReadoutSegment eventid( theCrate -> GetModule( "evtid" ), "EVENT ID" );
  TReadoutSegment fadc( theCrate -> GetModule( "daughter" ), "ADC" );
  sec2.push_back( eventid );
  sec2.push_back( fadc );
  event -> push_back( sec2 );



  // define book
  book -> AddReadoutList( runbegin );
  book -> AddReadoutList( runend );
  book -> AddReadoutList( event );



  return( book );
}
