// ============================================================================
//  $Id: StRunAction.hh,v 1.1.1.1 2003/01/04 08:07:14 iwai Exp $
//  $Name:  $
// ============================================================================
#ifndef __STRUNACTION_HH
#define __STRUNACTION_HH

#include "TRunAction.hh"
#include "TOutputHtmlFileStream.hh"

class TRun;
class TOutputObjectFile;
class TInputObjectFile;
class TDataRecord;
class StRunSummary;

class StRunAction
  : public TRunAction
{

  private:
    TOutputObjectFile* theOutputFile;
    StRunSummary* theRunSummary;
    TOutputHtmlFileStream theOutputHtml;

  public:
    StRunAction();
    ~StRunAction();

  public:
    Tvoid BeginOfRunAction( TRun& aRun );
    Tvoid EndOfRunAction( TRun& aRun );
    Tvoid FinalOfRunAction( TRun& aRun );

  public:
    TOutputObjectFile* GetOutputFile() const;
    StRunSummary* GetRunSummary() const;
    TOutputHtmlFileStream& GetOutputHtml();
    //Tbool IsExist( const Tstring& filename ) const;

  private:
    Tvoid fillRunBeginInformation( const TDataRecord& record );
    Tvoid fillRunEndInformation( const TDataRecord& record );
    Tvoid fillHtmlFile();
    Tvoid setFileName( Tint runid, Tstring& drecfile, Tstring& htmlfile );

};

inline TOutputObjectFile* StRunAction::GetOutputFile() const
{
  return( theOutputFile );
}

inline StRunSummary* StRunAction::GetRunSummary() const
{
  return( theRunSummary );
}

inline TOutputHtmlFileStream& StRunAction::GetOutputHtml()
{
  return( theOutputHtml );
}

#endif
