// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#include "StSinglePixel.hh"

StSinglePixel::StSinglePixel( Tint h, Tint v, Tdouble signal, Tdouble dark, Tdouble rms )
  : theHorizontalID( h ), theVerticalID( v ),
    theSignal( signal ), theDark( dark ), theRms( rms )
{;}

StSinglePixel::StSinglePixel( const StSinglePixel& right )
  : theHorizontalID( right.theHorizontalID ),
    theVerticalID( right.theVerticalID ),
    theSignal( right.theSignal ),
    theDark( right.theDark ),
    theRms( right.theRms )
{;}

StSinglePixel::~StSinglePixel()
{;}

const StSinglePixel& StSinglePixel::operator=( const StSinglePixel& right )
{
  theHorizontalID = right.theHorizontalID;
  theVerticalID = right.theVerticalID;
  theSignal = right.theSignal;
  theDark = right.theDark;
  theRms = right.theRms;
  return( *this );
}

Tbool StSinglePixel::operator==( const StSinglePixel& right ) const
{
  Tbool retval = Ttrue;
  retval &= ( theHorizontalID == right.theHorizontalID );
  retval &= ( theVerticalID == right.theVerticalID );
  retval &= ( theSignal == right.theSignal );
  retval &= ( theDark == right.theDark );
  retval &= ( theRms == right.theRms );
  return( retval );
}

Tbool StSinglePixel::operator!=( const StSinglePixel& right ) const
{
  Tbool retval = Tfalse;
  retval |= ( theHorizontalID != right.theHorizontalID );
  retval |= ( theVerticalID != right.theVerticalID );
  retval |= ( theSignal != right.theSignal );
  retval |= ( theDark != right.theDark );
  retval |= ( theRms != right.theRms );
  return( retval );
}

Tostream& operator<<( Tostream& tos, const StSinglePixel& right )
{
  tos << right.theHorizontalID << Tspace;
  tos << right.theVerticalID << Tspace;
  tos << right.theSignal << Tspace;
  tos << right.theDark << Tspace;
  tos << right.theRms << Tflush;
  return( tos );
}

Tistream& operator>>( Tistream& tis, StSinglePixel& right )
{
  return( tis >> right.theHorizontalID >> right.theVerticalID >> right.theSignal >> right.theDark >> right.theRms );
}
