// ============================================================================
//  $Id: TAnalysisManager.hh,v 1.1.1.1 2003/01/04 08:07:14 iwai Exp $
//  $Name:  $
// ============================================================================
#ifndef __TANALYSISMANAGER_HH
#define __TANALYSISMANAGER_HH

#include "Tglobals.h"
#include "TAnalyser.hh"
#include "TAnalysisStatusTable.hh"
#include "TAnalysisAction.hh"

class TExtractor;

class TAnalysisManager
{

  protected:
    static TAnalysisManager* theAnalysisManager;

  protected:
    TAnalysisStatusTable theStatusTable;
    TAnalyser* theAnalyser;
    TAnalysisAction* theAnalysisAction;

  public:
    TAnalysisManager( TAnalyser* analyser = 0 );
    virtual ~TAnalysisManager();

  public:
    virtual Tvoid StartAnalysis( const Tstring& id );
    virtual Tvoid StopAnalysis( const Tstring& id );
    virtual Tvoid UpdateAnalysis( const Tstring& id );
    virtual Tvoid SuspendAnalysis( const Tstring& id );
    virtual Tvoid ResumeAnalysis( const Tstring& id );
    virtual Tvoid StartAnalysis();
    virtual Tvoid StopAnalysis();
    virtual Tvoid UpdateAnalysis();
    virtual Tvoid SuspendAnalysis();
    virtual Tvoid ResumeAnalysis();

  public:
    virtual Tvoid ShowStatus() const;

  public:
    TAnalyser* GetAnalyser() const;
    Tvoid SetAnalyser( TAnalyser* analyser );
    Tvoid SetExtractor( TExtractor* extractor );
    const TAnalysisStatusTable& GetStatusTable() const;
    TAnalysisStatusTable& GetStatusTable();
    Tvoid SetStatusTable( const TAnalysisStatusTable& table );
    TAnalysisAction* GetAnalysisAction() const;
    Tvoid SetAnalysisAction( TAnalysisAction* action );

  public:
    virtual Tvoid GoAnalysisLoop( const Tstring& id );
    virtual Tvoid WaitReturnFromAnalysisLoop( const Tstring& id );

  protected:
    static Tvoid* doAnalysisLoop( Tvoid* arguments );

  public:
    static TAnalysisManager* GetAnalysisManager();

};

inline TAnalysisManager* TAnalysisManager::GetAnalysisManager()
{
  if ( theAnalysisManager == 0 )
    return( 0 );
  return( theAnalysisManager );
}

inline TAnalyser* TAnalysisManager::GetAnalyser() const
{
  return( theAnalyser );
}

inline const TAnalysisStatusTable& TAnalysisManager::GetStatusTable() const
{
  return( theStatusTable );
}

inline TAnalysisStatusTable& TAnalysisManager::GetStatusTable()
{
  return( theStatusTable );
}

inline Tvoid TAnalysisManager::SetStatusTable( const TAnalysisStatusTable& table )
{
  theStatusTable = table;
  return;
}

inline Tvoid TAnalysisManager::SetExtractor( TExtractor* extractor )
{
  if ( theAnalyser != 0 )
    theAnalyser -> AddExtractor( extractor );
  return;
}

inline TAnalysisAction* TAnalysisManager::GetAnalysisAction() const
{
  return( theAnalysisAction );
}

#endif
