// ============================================================================
//  $Id: TRunEventLimitCommand.cc,v 1.1.1.1 2003/01/04 08:07:14 iwai Exp $
//  $Name:  $
// ============================================================================
#include "TRunEventLimitCommand.hh"
#include "TRunManager.hh"

static const Tstring _name = "/run/eventlimit";
static const Tstring _desc = "set number of events taken in this run.\nif you want to cancel this limit, set to 0 or less.\nexample> /run/eventlimit 100";

TRunEventLimitCommand::TRunEventLimitCommand( TRunManager* manager )
  : TCommand( manager, _name, _desc )
{;}

TRunEventLimitCommand::~TRunEventLimitCommand()
{;}

Tvoid TRunEventLimitCommand::Execute( const TstringList& arguments )
{
  if ( arguments.empty() ) {
    Tcout << theRunManager -> GetEventLimit() << Tendl;
    return;
  }

  static const Tstring head = "TRunEventLimitCommand::Execute: ";
  Tstatus_t status = theRunManager -> GetStatus();
  if ( status == tStatusStandby ) {
    if ( arguments.size() == 1 ) {
      Tint nevents = strtol( arguments[ 0 ].c_str(), 0, 0 );
      theRunManager -> SetEventLimit( nevents );
    } else {
      ShowCommandDetail();
    }
  } else {
    theRunManager -> ShowStatus();
    Tcerr << head << "status of RunManager must be Standby." << Tendl;
  }
  return;
}
