// ============================================================================
//  $Id: TSetEnvironmentVariableCommand.cc,v 1.1.1.1 2003/01/04 08:07:14 iwai Exp $
//  $Name:  $
// ============================================================================
#include "TSetEnvironmentVariableCommand.hh"
#include "TEnvironmentVariableTable.hh"

static const Tstring _name = "setenv";
static const Tstring _desc = "change or add an environment variable.\nexample> setenv ITEM value\nexample> setenv rcfile";

TSetEnvironmentVariableCommand::TSetEnvironmentVariableCommand( TRunManager* manager, TEnvironmentVariableTable* table )
  : TCommand( manager, _name, _desc ), TEnvironmentVariableCommand( table )
{;}

TSetEnvironmentVariableCommand::~TSetEnvironmentVariableCommand()
{;}

Tvoid TSetEnvironmentVariableCommand::Execute( const TstringList& arguments )
{
  static const Tstring head = "TSetEnvironmentVariableCommand::Execute: ";

  if ( arguments.empty() ) {
    Tcerr << head << "select no item and no value." << Tendl;
    ShowCommandDetail();
  } else if ( arguments.size() == 1 ) {
    theEnvironmentVariableTable -> SetEnvironment( arguments[ 0 ] );
  } else if ( arguments.size() == 2 ) {
    theEnvironmentVariableTable -> SetEnvironment( arguments[ 0 ], arguments[ 1 ] );
  } else {
    ShowCommandDetail();
  }
  return;
}
