// ============================================================================
//  $Id: TUnsetEnvironmentVariableCommand.cc,v 1.1.1.1 2003/01/04 08:07:14 iwai Exp $
//  $Name:  $
// ============================================================================
#include "TUnsetEnvironmentVariableCommand.hh"
#include "TEnvironmentVariableTable.hh"

static const Tstring _name = "unsetenv";
static const Tstring _desc = "deletes the variable from the table.\nexample> unsetenv ITEM";

TUnsetEnvironmentVariableCommand::TUnsetEnvironmentVariableCommand( TRunManager* manager, TEnvironmentVariableTable* table )
  : TCommand( manager, _name, _desc ), TEnvironmentVariableCommand( table )
{;}

TUnsetEnvironmentVariableCommand::~TUnsetEnvironmentVariableCommand()
{;}

Tvoid TUnsetEnvironmentVariableCommand::Execute( const TstringList& arguments )
{
  static const Tstring head = "TUnsetEnvironmentVariableCommand::Execute: ";

  if ( arguments.empty() ) {
    Tcerr << head << "select no item." << Tendl;
    ShowCommandDetail();
  } else if ( arguments.size() == 1 ) {
    theEnvironmentVariableTable -> UnsetEnvironment( arguments[ 0 ] );
  } else {
    ShowCommandDetail();
  }
  return;
}
