// ============================================================================
//  $Id: TCrate.hh,v 1.1.1.1 2003/01/04 08:07:14 iwai Exp $
//  $Name:  $
// ============================================================================
#ifndef __TCRATE_HH
#define __TCRATE_HH

#include "Tglobals.h"
#include "TModuleSpecifiedTable.hh"

class TModule;

class TCrate
{

  private:
    TModule** theModuleList;
    TModuleSpecifiedTable theModuleSpecifiedTable;
    Tint theCrateCapacity;
    Tint theNumberOfModules;
    Tint theCrateIndex;

  public:
    TCrate();
    ~TCrate();

  public:
    Tint InstallModule( TModule* module, const Tstring& id, const TstringList& group );
    Tint InstallModule( TModule* module, const Tstring& id, const Tstring& group = "" );
    Tint RemoveModule( Tint index );
    Tint RemoveModule( const Tstring& id );
    Tint RemoveModule( const TstringList& groups );
    Tvoid ClearCrate();
    Tbool ResizeCrate( Tint capacity );
    TModule* NextModule();
    TModule* FindModule( const Tstring& id );
    TModule* GetModule( Tint index );
    TModule* GetModule( const Tstring& id );
    TModule* GetModule();

  private:
    Tvoid free();
    Tvoid allocate( Tint capacity );

  public:
    const TModuleSpecifiedTable& GetModuleSpecifiedTable() const;
    TModuleSpecifiedTable& GetModuleSpecifiedTable();
    Tint GetCrateCapacity() const;
    Tint GetNumberOfModules() const;
    Tint GetCrateIndex() const;
    Tvoid SetModuleSpecifiedTable( const TModuleSpecifiedTable& table );
    Tvoid SetCrateIndex( Tint index );

  public:
    Tvoid Clear( const TstringList& groups );
    Tvoid Clear( const Tstring& group );
    Tvoid Update( const TstringList& groups );
    Tvoid Update( const Tstring& group );
    Tvoid Initialize( const TstringList& groups );
    Tvoid Initialize( const Tstring& group );
    Tvoid ClearAllModules();
    Tvoid UpdateAllModules();
    Tvoid InitializeAllModules();
    Tvoid ClearModule( const Tstring& id );
    Tvoid UpdateModule( const Tstring& id );
    Tvoid InitializeModule( const Tstring& id );

};

inline const TModuleSpecifiedTable& TCrate::GetModuleSpecifiedTable() const
{
  return( theModuleSpecifiedTable );
}

inline TModuleSpecifiedTable& TCrate::GetModuleSpecifiedTable()
{
  return( theModuleSpecifiedTable );
}

inline Tint TCrate::GetCrateCapacity() const
{
  return( theCrateCapacity );
}

inline Tint TCrate::GetNumberOfModules() const
{
  return( theNumberOfModules );
}

inline Tint TCrate::GetCrateIndex() const
{
  return( theCrateIndex );
}

inline Tvoid TCrate::SetModuleSpecifiedTable( const TModuleSpecifiedTable& table )
{
  theModuleSpecifiedTable = table;
  return;
}

inline Tvoid TCrate::SetCrateIndex( Tint index )
{
  theCrateIndex = index;
  return;
}

#endif
