// ============================================================================
//  $Id: TSoftwareClockModule.cc,v 1.1.1.1 2003/01/04 08:07:14 iwai Exp $
//  $Name:  $
// ============================================================================
#include "TSoftwareClockModule.hh"
#include "TDataSegment.hh"
#include "TDataElement.hh"

static const Tstring _defaultformat = "%Y/%m/%d %a %H:%M:%S %z %Z";
Tstring TSoftwareClockModule::theCompleteTimeFormat = _defaultformat;

TSoftwareClockModule::TSoftwareClockModule( Tint nchannel )
  : TSoftwareModule( nchannel ), theCompleteTime(), 
    theLocalYear(), theLocalMonth(),
    theLocalDate(), theLocalDay(), theLocalHour(), theLocalMinute(),
    theLocalSecond(), theLocalTimeZone()
{
  setCurrentTime();
}

TSoftwareClockModule::TSoftwareClockModule( const TSoftwareClockModule& right )
  : TSoftwareModule( right ), 
    theCompleteTime( right.theCompleteTime ),
    theLocalYear( right.theLocalYear ),
    theLocalMonth( right.theLocalMonth ),
    theLocalDate( right.theLocalDate ),
    theLocalDay( right.theLocalDay ),
    theLocalHour( right.theLocalHour ),
    theLocalMinute( right.theLocalMinute ),
    theLocalSecond( right.theLocalSecond ),
    theLocalTimeZone( right.theLocalTimeZone )
{
  SetCompleteTimeFormat( right.GetCompleteTimeFormat() );
}

TSoftwareClockModule::~TSoftwareClockModule()
{;}

Tint TSoftwareClockModule::Clear()
{
  theCompleteTime.erase();
  theLocalYear.erase();
  theLocalMonth.erase();
  theLocalDate.erase();
  theLocalDay.erase();
  theLocalHour.erase();
  theLocalMinute.erase();
  theLocalSecond.erase();
  theLocalTimeZone.erase();
  return( theStatus = tStatusSuccess );
}

Tint TSoftwareClockModule::Update()
{
  setCurrentTime();
  return( theStatus = tStatusSuccess );
}

Tint TSoftwareClockModule::Initialize()
{
  Clear();
  SetCompleteTimeFormat( _defaultformat );
  return( theStatus = tStatusSuccess );
}

Tvoid TSoftwareClockModule::FillData( TDataElement& element, Tint channel )
{
  Update();
  if ( channel < 0 || channel >= theNumberOfChannels ) {
    theStatus = -EFAULT;
    Tcerr << "TSoftwareClockModule::FillData: invalid ID " << channel << Tendl;
    element.FillData( &theStatus, tTypeInt, 1 );
  } else {
    Tstring str = getStringData( channel );
    element.FillData( &str, tTypeString, 1 );
  }
  return;
}

const TSoftwareClockModule& TSoftwareClockModule::operator=( const TSoftwareClockModule& right )
{
  *( (TSoftwareModule*)this ) = *( (TSoftwareModule*)(&right) );
  theCompleteTime = right.theCompleteTime;
  SetCompleteTimeFormat( right.GetCompleteTimeFormat() );
  theLocalYear = right.theLocalYear;
  theLocalMonth = right.theLocalMonth;
  theLocalDate = right.theLocalDate;
  theLocalDay = right.theLocalDay;
  theLocalHour = right.theLocalHour;
  theLocalMinute = right.theLocalMinute;
  theLocalSecond = right.theLocalSecond;
  theLocalTimeZone = right.theLocalTimeZone;

  return( *this );
}

Tbool TSoftwareClockModule::operator==( const TSoftwareClockModule& right ) const
{
  Tbool ret = Ttrue;
  ret &= ( *( (TSoftwareModule*)this ) == *( (TSoftwareModule*)(&right) ) );
  ret &= ( GetCompleteTimeFormat() == right.GetCompleteTimeFormat() );
  ret &= ( theLocalTimeZone == right.theLocalTimeZone );

  return( ret );
}

Tbool TSoftwareClockModule::operator!=( const TSoftwareClockModule& right ) const
{
  Tbool ret = Tfalse;
  ret |= ( *( (TSoftwareModule*)this ) != *( (TSoftwareModule*)(&right) ) );
  ret |= ( *( (TSoftwareModule*)this ) != *( (TSoftwareModule*)(&right) ) );
  ret |= ( GetCompleteTimeFormat() != right.GetCompleteTimeFormat() );
  ret |= ( theLocalTimeZone != right.theLocalTimeZone );

  return( ret );
}

Tvoid TSoftwareClockModule::setCurrentTime()
{
  static const Tsize_t max = 256;
  Ttime_t time_now = 0;
  time( &time_now );
  struct tm* tm_now = localtime( &time_now );

  Tchar* s = new Tchar[ max ];

  strftime( s, max, theCompleteTimeFormat.c_str(), tm_now );
  theCompleteTime = s;

  strftime( s, max, "%Y", tm_now );
  theLocalYear = s;

  strftime( s, max, "%B", tm_now );
  theLocalMonth = s;

  strftime( s, max, "%d", tm_now );
  theLocalDate = s;

  strftime( s, max, "%A", tm_now );
  theLocalDay = s;

  strftime( s, max, "%H", tm_now );
  theLocalHour = s;

  strftime( s, max, "%M", tm_now );
  theLocalMinute = s;

  strftime( s, max, "%S", tm_now );
  theLocalSecond = s;

  strftime( s, max, "%Z", tm_now );
  theLocalTimeZone = s;
  
  delete [] s;
  return;
}

const Tstring& TSoftwareClockModule::getStringData( Tint channel ) const
{
  switch( channel ) {
    case tCompleteTime:
      return( theCompleteTime );
      break;
    case tCompleteTimeFormat:
      return( TSoftwareClockModule::theCompleteTimeFormat );
      break;
    case tLocalYear:
      return( theLocalYear );
      break;
    case tLocalMonth:
      return( theLocalMonth );
      break;
    case tLocalDate:
      return( theLocalDate );
      break;
    case tLocalDay:
      return( theLocalDay );
      break;
    case tLocalHour:
      return( theLocalHour );
      break;
    case tLocalMinute:
      return( theLocalMinute );
      break;
    case tLocalSecond:
      return( theLocalSecond );
      break;
    case tLocalTimeZone:
      return( theLocalTimeZone );
      break;
    default:
      return( theCompleteTime );
      break;
  }
}
