// ============================================================================
//  $Id: TReadoutBook.hh,v 1.1.1.1 2003/01/04 08:07:14 iwai Exp $
//  $Name:  $
// ============================================================================
#ifndef __TREADOUTBOOK_HH
#define __TREADOUTBOOK_HH

#include "Tglobals.h"

class TReadoutList;
class TDataRecord;

class TReadoutBook
{

  private:
    TReadoutList** theReadoutBook;
    Tint theCapacity;
    Tint theNumberOfPages;
    Tint theIndex;

  public:
    TReadoutBook();
    ~TReadoutBook();

  public:
    Tint AddReadoutList( TReadoutList* readoutlist );
    Tint RemoveReadoutList( Tint index );
    Tint RemoveReadoutList( const Tstring& id );
    Tvoid ClearReadoutBook();
    Tbool ResizeReadoutBook( Tint capacity );
    TReadoutList* NextReadoutList();
    TReadoutList* FindReadoutList( const Tstring& id );
    TReadoutList* GetReadoutList( Tint index );
    TReadoutList* GetReadoutList( const Tstring& id );
    TReadoutList* GetReadoutList();

  private:
    Tvoid free();
    Tvoid allocate( Tint capacity );

  public:
    Tint GetCapacity() const;
    Tint GetNumberOfPages() const;
    Tint GetIndex() const;
    Tvoid SetIndex( Tint index );

  public:
    TDataRecord Read( const Tstring& id );

};

inline Tint TReadoutBook::GetCapacity() const
{
  return( theCapacity );
}

inline Tint TReadoutBook::GetNumberOfPages() const
{
  return( theNumberOfPages );
}

inline Tint TReadoutBook::GetIndex() const
{
  return( theIndex );
}

inline Tvoid TReadoutBook::SetIndex( Tint index )
{
  theIndex = index;
  return;
}

#endif
