// ============================================================================
//  $Id: TReadoutSection.cc,v 1.1.1.1 2003/01/04 08:07:14 iwai Exp $
//  $Name:  $
// ============================================================================
#include "TReadoutSection.hh"
#include "TDataSection.hh"

TReadoutSection::TReadoutSection( const Tstring& id )
  : TReadoutIdentification( id ), TReadoutSegmentList()
{;}

TReadoutSection::TReadoutSection( const TReadoutSection& right )
  : TReadoutIdentification( right ), TReadoutSegmentList( right )
{;}

TReadoutSection::~TReadoutSection()
{;}

TDataSection TReadoutSection::Read()
{
  TDataSection section( theID );

  for ( Tsize_t i = 0; i < size(); i ++ ) {
    section.push_back( ( (*this)[ i ] ).Read() );
  }

  return( section );
}

const TReadoutSection& TReadoutSection::operator=( const TReadoutSection& right )
{
  *( (TReadoutIdentification*)this ) = *( (TReadoutIdentification*)(&right) );
  *( (TReadoutSegmentList*)this ) = *( (TReadoutSegmentList*)(&right) );
  return( *this );
}

Tbool TReadoutSection::operator==( const TReadoutSection& right ) const
{
  Tbool ret = Ttrue;
  ret &= ( *( (TReadoutIdentification*)this ) == *( (TReadoutIdentification*)(&right) ) );
  ret &= ( *( (TReadoutSegmentList*)this ) == *( (TReadoutSegmentList*)(&right) ) );
  return( ret );
}

Tbool TReadoutSection::operator!=( const TReadoutSection& right ) const
{
  Tbool ret = Tfalse;
  ret |= ( *( (TReadoutIdentification*)this ) != *( (TReadoutIdentification*)(&right) ) );
  ret |= ( *( (TReadoutSegmentList*)this ) != *( (TReadoutSegmentList*)(&right) ) );
  return( ret );
}
