// ============================================================================
//  $Id: TBenchmark.cc,v 1.1.1.1 2003/01/04 08:07:14 iwai Exp $
//  $Name:  $
// ============================================================================
#include "TBenchmark.hh"

TBenchmark::TBenchmark()
  : theSystemTimer(), theSystemClock(), theStartTime(), theStopTime()
{;}

TBenchmark::~TBenchmark()
{;}

Tvoid TBenchmark::Start()
{
  theSystemTimer.Start();
  theStartTime = theSystemClock.WhatTimeIsItNow();
  return;
}

Tvoid TBenchmark::Pause()
{
  theSystemTimer.Pause();
  return;
}

Tvoid TBenchmark::Restart()
{
  theSystemTimer.Restart();
  return;
}

Tvoid TBenchmark::Stop()
{
  theSystemTimer.Stop();
  theStopTime = theSystemClock.WhatTimeIsItNow();
  return;
}

Tvoid TBenchmark::Reset()
{
  theSystemTimer.Reset();
  return;
}

Tvoid TBenchmark::Continue()
{
  theSystemTimer.Continue();
  return;
}

Tvoid TBenchmark::PrintResult()
{
  Tcout << *this << Tendl;
  return;
}

Tostream& operator<<( Tostream& tos, const TBenchmark& right )
{
  Tcout << right.theStartTime << " -> " << right.theStopTime << Tendl;
  Tcout << right.theSystemTimer << Tflush;
  return( tos );
}
