// ============================================================================
//  $Id: TBenchmark.hh,v 1.1.1.1 2003/01/04 08:07:14 iwai Exp $
//  $Name:  $
// ============================================================================
#ifndef __TBENCHMARK_HH
#define __TBENCHMARK_HH

#include "Tglobals.h"
#include "TSystemTimer.hh"
#include "TSystemClock.hh"

class TSystemTimer;
class TSystemClock;

class TBenchmark
{

  protected:
    TSystemTimer theSystemTimer;
    TSystemClock theSystemClock;
    Tstring theStartTime;
    Tstring theStopTime;

  public:
    TBenchmark();
    virtual ~TBenchmark();

  public:
    virtual Tvoid Start();
    virtual Tvoid Pause();
    virtual Tvoid Restart();
    virtual Tvoid Stop();
    virtual Tvoid Reset();
    virtual Tvoid Continue();
    virtual Tvoid PrintResult();

  public:
    friend Tostream& operator<<( Tostream& tos, const TBenchmark& right );

  public:
    const TSystemTimer& GetSystemTimer() const;
    const TSystemClock& GetSystemClock() const;
    const Tstring& GetStartTime() const;
    const Tstring& GetStopTime() const;
    Tvoid SetStartTime( const Tstring& time );
    Tvoid SetStopTime( const Tstring& time );

};

inline const TSystemTimer& TBenchmark::GetSystemTimer() const
{
  return( theSystemTimer );
}

inline const TSystemClock& TBenchmark::GetSystemClock() const
{
  return( theSystemClock );
}

inline const Tstring& TBenchmark::GetStartTime() const
{
  return( theStartTime );
}

inline const Tstring& TBenchmark::GetStopTime() const
{
  return( theStopTime );
}

inline Tvoid TBenchmark::SetStartTime( const Tstring& time )
{
  theStartTime = time;
  return;
}

inline Tvoid TBenchmark::SetStopTime( const Tstring& time )
{
  theStopTime = time;
  return;
}

#endif
