// ============================================================================
//  $Id: Tglobals.h,v 1.2 2003/01/20 11:14:18 iwai Exp $
//  $Name:  $
// ============================================================================
#ifndef __TGLOBALS_H
#define __TGLOBALS_H

#include <pthread.h>

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include <X11/cursorfont.h>
#include <X11/keysym.h>
#include <X11/xpm.h>

#include <stdio.h>
#include <string.h>
#include <fstream>
#include <stdlib.h>
#include <time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/un.h>
#include <fcntl.h>
#include <sys/time.h>
#include <sys/times.h>
#include <errno.h>
#include <math.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <signal.h>
#include <sys/ioctl.h>
#include <sys/ipc.h>
#include <sys/sem.h>
#include <sys/shm.h>
#include <sys/wait.h>
#include <termios.h>
#include <sys/mman.h>
#include <term.h>
#include <ncurses.h>
#include <unistd.h>

#ifdef __CCD_ROOT_USE
#include <TROOT.h>
#include <TSystem.h>
#include <TApplication.h> 
#include <TStyle.h>
#include <TGraph.h>
#include <TH1.h>
#include <TH2.h>
#include <TCanvas.h>
#include <TNtuple.h>
#include <TFile.h>
#include <TPad.h>
#endif

#ifdef __CCD_ZLIB_USE
#include <zlib.h>
#endif

#include <linux/param.h>

#ifndef __USE_BSD
typedef __caddr_t caddr_t;
#endif

#if defined(__GNU_LIBRARY__) && !defined(_SEM_SEMUN_UNDEFINED)
// see <sys/sem.h>
#else
// if defer to X/OPEN design
union semun {
  int val;                    // value for SETVAL
  struct semid_ds* buf;       // buffer for IPC_STAT, IPC_SET
  unsigned short int* array;  // array for GETALL, SETALL
  struct seminfo* __buf;      // buffer for IPC_INFO
};
#endif

#include "Ttypes.h"

extern Tchar** environ;

inline static Tstring itostr( Tint i )
{
  static const Tsize_t maxlen = 256;
  Tchar* s = new Tchar[ maxlen ];
  snprintf( s, maxlen, "%d", i );
  Tstring retstr = s;
  delete [] s;
  return( retstr );
}

inline static Tstring ltostr( Tlong l )
{
  static const Tsize_t maxlen = 256;
  Tchar* s = new Tchar[ maxlen ];
  snprintf( s, maxlen, "%d", (Tint)l );
  Tstring retstr = s;
  delete [] s;
  return( retstr );
}

inline static Tstring ultostr( TUlong ul )
{
  static const Tsize_t maxlen = 256;
  Tchar* s = new Tchar[ maxlen ];
  snprintf( s, maxlen, "%u", (TUint)ul );
  Tstring retstr = s;
  delete [] s;
  return( retstr );
}

inline static Tstring dtostr( Tdouble d )
{
  static const Tsize_t maxlen = 256;
  Tchar* s = new Tchar[ maxlen ];
  snprintf( s, maxlen, "%f", d );
  Tstring retstr = s;
  delete [] s;
  return( retstr );
}

inline Tbool isexist( const Tstring& filename )
{
  TFileStream* fp = fopen( filename.c_str(), "r" );
  if ( fp == 0 ) {
    return( Tfalse );
  } else {
    fclose( fp );
    return( Ttrue );
  }
}

#endif
