// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#include "TDataInflation.hh"

int main( int argc, char** argv, char** envv )
{
  if ( argc != 3 ) {
    Tcerr << "usage: " << argv[ 0 ] << " <input> <output>" << Tendl;
    return( -1 );
  }
  const Tstring ifname = argv[ 1 ];
  const Tstring ofname = argv[ 2 ];

  TDataInflation inflation;

  const Tsize_t bufsize = 256;
  Tvoid* input = new Tbyte[ bufsize ];

  Tifstream ifs;
  ifs.open( ifname.c_str() );

  Tofstream ofs;
  ofs.open( ofname.c_str() );

  while ( ifs.good() && !ifs.eof() ) {
    ifs.read( input, bufsize );
    inflation.Decompress( input, ifs.gcount() );
    ofs.write( inflation.GetInflatedData(), inflation.GetSizeOfInflatedData() );
  }

  ifs.close();
  ofs.close();

  return( 0 );
}
