// ============================================================================
//  $Id: find.cc,v 1.1.1.1 2003/01/04 08:07:14 iwai Exp $
//  $Name:  $
// ============================================================================
#include "TDataRecord.hh"
#include "TDataElement.hh"
#include "TInputObjectFile.hh"
#include "TBenchmark.hh"

int main( int argc, char** argv, char** envv )
{
  if ( argc != 2 ) {
    Tcerr << "usage: " << argv[ 0 ] << Tspace << "<filename>" << Tendl;
    return( -1 );
  }
  const Tstring filename = argv[ 1 ];
  TInputObjectFile ifile( filename );


  static const Tstring sectag = "This section is for software modules.";
  static const Tstring segtag = "ADC";
  static const Tstring eletag = "channel 5";

  Tstring findtag[ 3 ] = { sectag, segtag, eletag };

  TDataRecord record;
  TDataElement element;
  TBenchmark bench;
  bench.Start();
  while ( ( ifile >> record ) != 0 ) {
    if ( record.FindDataElement( findtag, element ) ) {
      Tcout << element << Tendl;
    }
  }
  bench.Stop();
  Tcout << bench << Tendl;

  return( 0 );
}
