// =====================================================================
//  $Id: St00RunAction.hh,v 1.4 2003/10/06 16:28:17 goiwai Exp $
//  $Name: CLDAQ-1-11-00 $
//  $Log: St00RunAction.hh,v $
//  Revision 1.4  2003/10/06 16:28:17  goiwai
//  *** empty log message ***
//
//  Revision 1.3  2003/07/30 16:15:52  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#ifndef __ST0001RUNACTION_HH
#define __ST0001RUNACTION_HH

#include "TRunAction.hh"
#include "TOutputHtmlFileStream.hh"

class TRun;
class TOutputObjectFile;
class TInputObjectFile;
class TDataRecord;
class St00RunSummary;

class St00RunAction
  : public TRunAction
{

  private:
    TOutputObjectFile* theOutputFile;
    St00RunSummary* theRunSummary;
    TOutputHtmlFileStream theOutputHtml;

  public:
    St00RunAction();
    ~St00RunAction();

  public:
    Tvoid BeginOfRunAction( TRun& aRun );
    Tvoid EndOfRunAction( TRun& aRun );

  public:
    TOutputObjectFile* GetOutputFile() const;
    St00RunSummary* GetRunSummary() const;
    TOutputHtmlFileStream& GetOutputHtml();

  private:
    Tvoid fillRunBeginInformation( const TDataRecord& record );
    Tvoid fillRunEndInformation( const TDataRecord& record );
    Tvoid setFileName( Tint runid, Tstring& drecfile, Tstring& htmlfile );

};

inline TOutputObjectFile* St00RunAction::GetOutputFile() const
{
  return theOutputFile;
}

inline St00RunSummary* St00RunAction::GetRunSummary() const
{
  return theRunSummary;
}

inline TOutputHtmlFileStream& St00RunAction::GetOutputHtml()
{
  return theOutputHtml;
}

#endif
