#! /usr/bin/env perl

use strict;
use Getopt::Std;

my %counter;
my $c = 0;


# ñ̽
sub month {
  foreach (reverse (<>)) {
    $c += length($_);
    if (/^(\d{4}-\d\d)/) {
      $counter{$1} += $c;
      $c = 0;
    }
  }
}

sub day {
  # ñ̤ν
  foreach (reverse (<>)) {
    $c += length($_);
    if (/^(\d{4}-\d{2}-\d{2})/) {
      $counter{$1} += $c;
      $c = 0;
    }
  }
}

sub dump() {
  my $out=$_[0];
  if ($out) {
    open(OUT,">$out");
    foreach (sort keys %counter) {
      print OUT "$_\t$counter{$_}\n";
    }
    close(OUT);
  } else {
    foreach (sort keys %counter) {
      print "$_\t$counter{$_}\n";
    }
  }
}

sub usage {
print <<EOF;
Usage: logsizebyday [OPTION] <ChangeLog>...
  -h		print this message
  -d		print by day
  -m		print by month
  -o<out>	print to out
EOF
exit;
}

sub main() {
  my %options;
  getopts('hmdo:', \%options);
  #use Data::Dumper;
  #print Dumper \%options;
  $options{'h'} && usage();

  foreach (@ARGV) {
    if ($options{'d'}) {
      &day();
    } elsif ($options{'m'}) {
      &month();
    } else {
      &day();
    }
    &dump($options{'o'});
  }
}

&main();

1;
