// =====================================================================
//  $Id: Rs01RunAction.hh,v 1.4 2004/01/19 21:10:27 goiwai Exp $
//  $Name: CLDAQ-1-12-00 $
//  $Log: Rs01RunAction.hh,v $
//  Revision 1.4  2004/01/19 21:10:27  goiwai
//  ץץåƬCLDAQ__ѹޤ.
//
//  Revision 1.3  2003/10/06 16:28:15  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:14:41  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#ifndef CLDAQ__RS01RUNACTION_HH
#define CLDAQ__RS01RUNACTION_HH

#include "TRunAction.hh"
#include "TOutputHtmlFileStream.hh"

class TRun;
class TOutputObjectFile;
class TInputObjectFile;
class TDataRecord;
class Rs01RunSummary;

class Rs01RunAction
  : public TRunAction
{

  private:
    TOutputObjectFile* theOutputFile;
    Rs01RunSummary* theRunSummary;
    TOutputHtmlFileStream theOutputHtml;

  public:
    Rs01RunAction();
    ~Rs01RunAction();

  public:
    Tvoid BeginOfRunAction( TRun& aRun );
    Tvoid EndOfRunAction( TRun& aRun );

  public:
    TOutputObjectFile* GetOutputFile() const;
    Rs01RunSummary* GetRunSummary() const;
    TOutputHtmlFileStream& GetOutputHtml();

  private:
    Tvoid fillRunBeginInformation( const TDataRecord& record );
    Tvoid fillRunEndInformation( const TDataRecord& record );
    Tvoid setFileName( Tint runid, Tstring& drecfile, Tstring& htmlfile );

};

inline TOutputObjectFile* Rs01RunAction::GetOutputFile() const
{
  return theOutputFile;
}

inline Rs01RunSummary* Rs01RunAction::GetRunSummary() const
{
  return theRunSummary;
}

inline TOutputHtmlFileStream& Rs01RunAction::GetOutputHtml()
{
  return theOutputHtml;
}

#endif
