// =====================================================================
//  $Id: Sw01RunAction.cc,v 1.1 2004/03/01 09:48:30 goiwai Exp $
//  $Name: CLDAQ-1-12-00 $
//  $Log: Sw01RunAction.cc,v $
//  Revision 1.1  2004/03/01 09:48:30  goiwai
//  sw01θǤѹǤ.
//  ۤȤƤѤޤ.
//  ̵Υ٥ȥǥץ쥤Ѱդޤ.
//
//  Revision 1.4  2003/10/06 16:28:16  goiwai
//  *** empty log message ***
//
//  Revision 1.3  2003/07/30 16:15:16  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TRun.hh"
#include "TRunManager.hh"
#include "TEventManager.hh"
#include "TSoftwareRunInformationModule.hh"
#include "TSoftwareScalerModule.hh"
#include "TOutputObjectFile.hh"
#include "TReadoutBook.hh"
#include "TReadoutList.hh"
#include "TDataRecord.hh"
#include "TDataElement.hh"
#include "TCrate.hh"
#include "TEnvironmentVariableTable.hh"

#include "Sw01RunAction.hh"
#include "Sw01SystemAction.hh"
#include "Sw01EventDisplay.hh"

Sw01RunAction::Sw01RunAction()
  : theOutputFile( 0 ), theOutputHtml(), theRunSummary()
{;}

Sw01RunAction::~Sw01RunAction()
{;}

Tvoid Sw01RunAction::BeginOfRunAction( TRun& aRun )
{
  const TEnvironmentVariableTable& envtable = 
    theRunManager -> GetEnvironmentVariableTable();
  Tstring drecdir = envtable.GetEnvironmentValue( "SW01_RECORD_DIR" );
  Tstring htmldir = envtable.GetEnvironmentValue( "SW01_SUMMARY_DIR" );

  Tint runid = aRun.GetRunID();
  Tstring filename = "run";
  Tstring runidstr = aRun.GetStringRunID();

  Tstring drecfile = drecdir + filename + runidstr + ".drec";
  Tstring htmlfile = htmldir + filename + runidstr + ".html";

  theCrate -> Initialize( "run begin initialize" );
  TSoftwareScalerModule* scaler = (TSoftwareScalerModule*)( theCrate -> GetModule( "Run ID" ) );
  scaler -> SetData( 0, runid );


  theOutputFile = new TOutputObjectFile( drecfile );
  TDataRecord record = theReadoutBook -> GetReadoutList( "RUN BEGIN" ) -> Read();
  *theOutputFile << record;
  theOutputHtml.Open( htmlfile );

  theRunSummary.Initialize();
  fillRunBeginInformation( record );


  Sw01SystemAction* sysaction =
    (Sw01SystemAction*)( theRunManager->GetSystemAction() );
  Sw01EventDisplay* evd = sysaction -> GetEventDisplay();

  evd -> Clear();


  return;
}

Tvoid Sw01RunAction::EndOfRunAction( TRun& aRun )
{
  TDataRecord record =
    theReadoutBook -> GetReadoutList( "RUN END" ) -> Read();
  *theOutputFile << record;

  fillRunEndInformation( record );
  fillHtmlFile();
  theOutputHtml.Close();

  delete theOutputFile;
  theOutputFile = 0;


  Sw01SystemAction* sysaction =
    (Sw01SystemAction*)( theRunManager->GetSystemAction() );
  Sw01EventDisplay* evd = sysaction -> GetEventDisplay();
  evd -> Save();


  return;
}

Tvoid Sw01RunAction::fillRunBeginInformation( const TDataRecord& record )
{
  static Tstring runidset[ 3 ] = { "Run Information", "Run ID", "0" };
  static Tstring clockset[ 3 ] = { "Run Information", "Clock", "0" };

  TDataElement runid;
  TDataElement clock;
  record.FindDataElement( runidset, runid );
  record.FindDataElement( clockset, clock );

  theRunSummary.SetRecordName( theOutputFile -> GetFileName() );
  theRunSummary.SetRunID( *( runid.GetIntData() ) );
  theRunSummary.SetRunBeginTime( *( clock.GetStringData() ) );

  return;
}

Tvoid Sw01RunAction::fillRunEndInformation( const TDataRecord& record )
{
  static Tstring clockset[ 3 ] = { "Run Information", "Clock", "0" };
  TDataElement clock;
  record.FindDataElement( clockset, clock );


  theRunSummary.SetRunInformationTable( theRunManager -> GetRunInformationModule() -> GetRunInformationTable() );
  theRunSummary.SetRunEndTime( *( clock.GetStringData() ) );
  theRunSummary.SetRecordSize( theOutputFile -> GetTotalDataSize() );
  theRunSummary.SetNumberOfEvents( theEventManager -> GetNumberOfEvents() );

  return;
}

Tvoid Sw01RunAction::fillHtmlFile()
{
  TRunInformationTable table = theRunSummary.GenerateRunSummaryTable();
  Tstring title = "Run Summary #" + ( theRunManager -> GetRun() ).GetStringRunID();
  theOutputHtml.SetTitle( title );

  theOutputHtml << table << Tendl;

  return;
}
