// =====================================================================
//  $Id: TReadFileCommand.cc,v 1.3 2003/10/06 17:02:37 goiwai Exp $
//  $Name: CLDAQ-1-12-00 $
//  $Log: TReadFileCommand.cc,v $
//  Revision 1.3  2003/10/06 17:02:37  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:17:32  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TReadFileCommand.hh"
#include "TInputObjectFile.hh"
#include "TDataRecord.hh"

static const Tstring _name = "/option/readfile";
static const Tstring _desc = "open a object file, dump to screen.\nexample> /option/readfile filename.drec";

TReadFileCommand::TReadFileCommand( TRunManager* manager )
  : TCommand( manager, _name, _desc )
{;}

TReadFileCommand::~TReadFileCommand()
{;}

Tvoid TReadFileCommand::Execute( const TstringList& arguments )
{
  if ( arguments.size() != 1 ) {
    ShowCommandDetail();
    return;
  }

  const Tstring filename = arguments[ 0 ];
  TInputObjectFile* ifile = new TInputObjectFile( filename );
  Tint nevents = 0;
  Tint datasize = 0;

  TDataRecord record;
  while ( ( ifile -> Read( record ) ) != 0 ) {
    Tcout << record << Tendl;
    datasize += record.GetRecordSize();
    nevents ++;
  }

  Tcout << nevents << " events, ";
  Tcout << datasize << Tslash << ifile -> GetTotalDataSize();
  Tcout << " byte data has been read from " << filename << "." << Tendl;

  delete ifile;

  return;
}
