// =====================================================================
/*!
//
//  \file TCamacOutputRegisterModule.hh
//  \brief This file contains the TCamacOutputRegisterModule class.
//  \author Go IWAI <goiwai@users.sourceforge.jp>
//
//  $Id: TCamacOutputRegisterModule.hh,v 1.5 2004/01/19 21:09:41 goiwai Exp $
//  $Name: CLDAQ-1-12-00 $
//  $Log: TCamacOutputRegisterModule.hh,v $
//  Revision 1.5  2004/01/19 21:09:41  goiwai
//  ץץåƬCLDAQ__ѹޤ.
//
//  Revision 1.4  2003/11/03 08:35:13  goiwai
//  DoxygenѤΥȥȤ򤦤Ǥߤ򳫻Ϥޤ.
//
//  Revision 1.3  2003/10/06 17:02:40  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:19:10  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
*/
// =====================================================================
#ifndef CLDAQ__TCAMACOUTPUTREGISTERMODULE_HH
#define CLDAQ__TCAMACOUTPUTREGISTERMODULE_HH

#include "Tglobals.h"
#include "TCamacModule.hh"

class TDataSegment;
class TDataElement;


/*!
// \example
//
// If example code exists.
//
*/

/*!
// \class TCamacOutputRegisterModule
// \brief This is the TCamacOutputRegisterModule class.
// \author Go IWAI <goiwai@users.sourceforge.jp>
//
// The TCamacOutputRegisterModule class detail description.
// Write it down ASAP!
//
// \todo None?
// \bug None?
// \ingroup ModulesCategory
*/
class TCamacOutputRegisterModule
  : public TCamacModule
{

  public:
    TCamacOutputRegisterModule( TCamacCrateController* cc7x00, Tint slot, Tdata_t datalen = t16bitModule );
    TCamacOutputRegisterModule( const TCamacOutputRegisterModule& right );
    ~TCamacOutputRegisterModule();

  public:
    const TCamacOutputRegisterModule& operator=( const TCamacOutputRegisterModule& right );
    Tbool operator==( const TCamacOutputRegisterModule& right ) const;
    Tbool operator!=( const TCamacOutputRegisterModule& right ) const;
    Tvoid FillData( TDataElement& element, Tint channel );

  public:
    Tint Pulse( Tint data );
    Tint Level( Tint data );

};

#endif
