// =====================================================================
/*!
//
//  \file TModuleSpecified.hh
//  \brief This file contains the TModuleSpecified class.
//  \author Go IWAI <goiwai@users.sourceforge.jp>
//
//  $Id: TModuleSpecified.hh,v 1.5 2004/01/19 21:09:41 goiwai Exp $
//  $Name: CLDAQ-1-12-00 $
//  $Log: TModuleSpecified.hh,v $
//  Revision 1.5  2004/01/19 21:09:41  goiwai
//  ץץåƬCLDAQ__ѹޤ.
//
//  Revision 1.4  2003/11/03 08:35:13  goiwai
//  DoxygenѤΥȥȤ򤦤Ǥߤ򳫻Ϥޤ.
//
//  Revision 1.3  2003/10/06 17:02:40  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:19:10  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
*/
// =====================================================================
#ifndef CLDAQ__TMODULESPECIFIED_HH
#define CLDAQ__TMODULESPECIFIED_HH

#include "Tglobals.h"

class TModule;


/*!
// \example
//
// If example code exists.
//
*/

/*!
// \class TModuleSpecified
// \brief This is the TModuleSpecified class.
// \author Go IWAI <goiwai@users.sourceforge.jp>
//
// The TModuleSpecified class detail description.
// Write it down ASAP!
//
// \todo None?
// \bug None?
// \ingroup ModulesCategory
*/
class TModuleSpecified
{

  private:
    Tstring theModuleID;
    TstringList theGroupIDs;
    TModule* theModule;

  public:
    TModuleSpecified();
    TModuleSpecified( const Tstring& id, const TstringList& groups, TModule* module );
    TModuleSpecified( const TModuleSpecified& right );
    ~TModuleSpecified();

  public:
    const TModuleSpecified& operator=( const TModuleSpecified& right );
    Tbool operator==( const TModuleSpecified& right ) const;
    Tbool operator!=( const TModuleSpecified& right ) const;
    friend Tostream& operator<<( Tostream& tos, const TModuleSpecified& right );

  public:
    const Tstring& GetModuleID() const;
    Tstring& GetModuleID();
    const TstringList& GetGroupIDs() const;
    TstringList& GetGroupIDs();
    TModule* GetModule() const;
    Tvoid SetModuleID( const Tstring& id );
    Tvoid SetGroupIDs( const TstringList& ids );
    Tvoid SetModule( TModule* module );
    Tbool IsSameGroup( const TModuleSpecified& spec );
    Tbool IsSameGroup( const TstringList& groups );
    Tbool IsSameGroup( const Tstring& group );

};

inline const Tstring& TModuleSpecified::GetModuleID() const
{
  return theModuleID;
}

inline Tstring& TModuleSpecified::GetModuleID()
{
  return theModuleID;
}

inline const TstringList& TModuleSpecified::GetGroupIDs() const
{
  return theGroupIDs;
}

inline TstringList& TModuleSpecified::GetGroupIDs()
{
  return theGroupIDs;
}

inline TModule* TModuleSpecified::GetModule() const
{
  return theModule;
}

inline Tvoid TModuleSpecified::SetModuleID( const Tstring& id )
{
  theModuleID = id;
  return;
}

inline Tvoid TModuleSpecified::SetGroupIDs( const TstringList& ids )
{
  theGroupIDs = ids;
  return;
}

inline Tvoid TModuleSpecified::SetModule( TModule* module )
{
  theModule = module;
  return;
}

#endif
