// =====================================================================
/*!
//
//  \file TInputObjectFilter.hh
//  \brief This file contains the TInputObjectFilter class.
//  \author Go IWAI <goiwai@users.sourceforge.jp>
//
//  $Id: TInputObjectFilter.hh,v 1.2 2004/01/19 21:09:41 goiwai Exp $
//  $Name: CLDAQ-1-12-00 $
//  $Log: TInputObjectFilter.hh,v $
//  Revision 1.2  2004/01/19 21:09:41  goiwai
//  ץץåƬCLDAQ__ѹޤ.
//
//  Revision 1.1  2003/12/06 10:18:15  goiwai
//  ϥե륿Ƚϥե륿̰ˤޤ.
//  Ͻ貾۴ؿFiltering()ޤߤޤ.
//
*/
// =====================================================================
#ifndef CLDAQ__TINPUTOBJECTFILTER_HH
#define CLDAQ__TINPUTOBJECTFILTER_HH

#include "Tglobals.h"
#include "TObjectFilter.hh"

class TStreamableObject;
class TInputObjectStream;
class TInputObjectStream;
class TObjectStream;
class TInputObjectFilter;

/*!
// \example
//
// If example code exists.
//
*/

/*!
// \class TInputObjectFilter
// \brief This is the TInputObjectFilter class.
// \author Go IWAI <goiwai@users.sourceforge.jp>
//
// The TInputObjectFilter class detail description.
// Write it down ASAP!
//
// \todo None?
// \bug None?
// \ingroup PersistencyCategory
*/
class TInputObjectFilter
  : public TObjectFilter
{

  public:
    TInputObjectFilter();
    virtual ~TInputObjectFilter();

  public:
    virtual Tint Filtering( TStreamableObject& object, TInputObjectStream* stream ) = 0;
    virtual Tvoid Initialize( TInputObjectStream* stream );
    virtual Tvoid Finalize( TInputObjectStream* stream );

};

inline Tvoid TInputObjectFilter::Initialize( TInputObjectStream* stream )
{
  return;
}

inline Tvoid TInputObjectFilter::Finalize( TInputObjectStream* stream )
{
  return;
}

#endif
