// =====================================================================
/*!
//
//  \file TObjectSocket.hh
//  \brief This file contains the TObjectSocket class.
//  \author Go IWAI <goiwai@users.sourceforge.jp>
//
//  $Id: TObjectSocket.hh,v 1.5 2004/01/19 21:09:41 goiwai Exp $
//  $Name: CLDAQ-1-12-00 $
//  $Log: TObjectSocket.hh,v $
//  Revision 1.5  2004/01/19 21:09:41  goiwai
//  ץץåƬCLDAQ__ѹޤ.
//
//  Revision 1.4  2003/11/03 08:35:13  goiwai
//  DoxygenѤΥȥȤ򤦤Ǥߤ򳫻Ϥޤ.
//
//  Revision 1.3  2003/10/06 17:02:42  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:19:31  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
*/
// =====================================================================
#ifndef CLDAQ__TOBJECTSOCKET_HH
#define CLDAQ__TOBJECTSOCKET_HH

#include "Tglobals.h"


/*!
// \example
//
// If example code exists.
//
*/

/*!
// \class TObjectSocket
// \brief This is the TObjectSocket class.
// \author Go IWAI <goiwai@users.sourceforge.jp>
//
// The TObjectSocket class detail description.
// Write it down ASAP!
//
// \todo None?
// \bug None?
// \ingroup PersistencyCategory
*/
class TObjectSocket
{

  protected:
    enum { tDefaultPortNumber = 18150 };

  protected:
    Tint theServerDescriptor;
    Tint thePortNumber;
    struct sockaddr_in theAddress;

  public:
    TObjectSocket( Tint portnumber );

  protected:
    virtual ~TObjectSocket();

  public:
    Tint GetServerDescriptor() const;
    Tint GetPortNumber() const;

  public:
    Tint OpenServer();
    Tint CloseServer();

};

inline Tint TObjectSocket::GetServerDescriptor() const
{
  return theServerDescriptor;
}

inline Tint TObjectSocket::GetPortNumber() const
{
  return thePortNumber;
}

#endif
