// ============================================================================
/*!
//
//  \file TFileProperty.hh
//  \brief This file contains the TFileProperty class.
//  \author Go IWAI <goiwai@users.sourceforge.jp>
//
//  $Id: TFileProperty.hh,v 1.5 2004/01/19 21:09:43 goiwai Exp $
//  $Name: CLDAQ-1-12-00 $
//  $Log: TFileProperty.hh,v $
//  Revision 1.5  2004/01/19 21:09:43  goiwai
//  ץץåƬCLDAQ__ѹޤ.
//
//  Revision 1.4  2003/11/03 08:35:15  goiwai
//  DoxygenѤΥȥȤ򤦤Ǥߤ򳫻Ϥޤ.
//
//  Revision 1.3  2003/10/12 13:06:34  goiwai
//  Update()ɲäޤ.
//
//  Revision 1.2  2003/10/11 03:06:23  goiwai
//  ʲΥдؿɲäޤ.
//  const Tstring& GetPathName() const;
//  const Tstring& GetDirectoryName() const;
//  const Tstring& GetFileName() const;
//  const Tstring& GetFileRootName() const;
//  const Tstring& GetFileExtensionName() const;
//
//  Revision 1.1  2003/10/06 16:37:37  goiwai
//  եξɽ뤿Υ饹Ǥ.
//
*/
// ============================================================================
#ifndef CLDAQ__TFILEPROPERTY_HH
#define CLDAQ__TFILEPROPERTY_HH

#include "Tglobals.h"


/*!
// \example
//
// If example code exists.
//
*/

/*!
// \class TFileProperty
// \brief This is the TFileProperty class.
// \author Go IWAI <goiwai@users.sourceforge.jp>
//
// The TFileProperty class detail description.
// Write it down ASAP!
//
// \todo None?
// \bug None?
// \ingroup SystemCategory
*/
class TFileProperty
{

  private:
    Tstring thePathName;
    Tstring theDirectoryName;
    Tstring theFileName;
    Tstring theFileRootName;
    Tstring theFileExtensionName;
    Tint theDeviceNumber;
    Tint theDeviceMajorNumber;
    Tint theDeviceMiorNumber;
    Tint theInodeNumber;
    Tint theProtection;
    Tint theNumberOfHardLinks;
    Tint theDeviceType;
    Tint theTotalSize;
    Tint theBlockSize;
    Tint theNumberOfBlocks;
    Tint theUserID;
    Tint theGroupID;
    Tint theLastAccess;
    Tint theLastModification;
    Tint theLastChange;
    Tstring theStringUserID;
    Tstring theStringGroupID;
    Tstring theStringLastAccess;
    Tstring theStringLastModification;
    Tstring theStringLastChange;

  public:
    TFileProperty();
    TFileProperty( const Tstring& path );
    TFileProperty( const TFileProperty& right );
    ~TFileProperty();

  public:
    const TFileProperty& operator=( const TFileProperty& right );
    Tbool operator==( const TFileProperty& right ) const;
    Tbool operator!=( const TFileProperty& right ) const;

  public:
    const Tstring& GetPathName() const;
    const Tstring& GetDirectoryName() const;
    const Tstring& GetFileName() const;
    const Tstring& GetFileRootName() const;
    const Tstring& GetFileExtensionName() const;
    Tint GetDeviceNumber() const;
    Tint GetDeviceMajorNumber() const;
    Tint GetDeviceMiorNumber() const;
    Tint GetInodeNumber() const;
    Tint GetProtection() const;
    Tint GetNumberOfHardLinks() const;
    Tint GetDeviceType() const;
    Tint GetTotalSize() const;
    Tint GetBlockSize() const;
    Tint GetNumberOfBlocks() const;
    Tint GetUserID() const;
    Tint GetGroupID() const;
    Tint GetLastAccess() const;
    Tint GetLastModification() const;
    Tint GetLastChange() const;
    const Tstring& GetStringUserID() const;
    const Tstring& GetStringGroupID() const;
    const Tstring& GetStringLastAccess() const;
    const Tstring& GetStringLastModification() const;
    const Tstring& GetStringLastChange() const;

  public:
    Tvoid SetPathName( const Tstring& path );
    Tvoid Analyse();
    Tvoid Update();
    // ChangeMode Ȥ Rename 򤹤 SetProtection(), SetUserID()

  public:
    Tbool IsCharacterDevice() const;
    Tbool IsBlockDevice() const;
    Tbool IsFIFO() const;
    Tbool IsSocket() const;
    Tbool IsSymbolicLink() const;
    Tbool IsRegularFile() const;
    Tbool IsDirectory() const;
    Tbool IsReadable() const;
    Tbool IsWritable() const;
    Tbool IsExecutable() const;

  public:
    friend Tostream& operator<<( Tostream& tos, const TFileProperty& right );

};

inline const Tstring& TFileProperty::GetPathName() const
{
  return thePathName;
}

inline const Tstring& TFileProperty::GetDirectoryName() const
{
  return theDirectoryName;
}

inline const Tstring& TFileProperty::GetFileName() const
{
  return theFileName;
}

inline const Tstring& TFileProperty::GetFileRootName() const
{
  return theFileRootName;
}

inline const Tstring& TFileProperty::GetFileExtensionName() const
{
  return theFileExtensionName;
}

inline Tint TFileProperty::GetDeviceNumber() const
{
  return theDeviceNumber;
}

inline Tint TFileProperty::GetDeviceMajorNumber() const
{
  return theDeviceMajorNumber;
}

inline Tint TFileProperty::GetDeviceMiorNumber() const
{
  return theDeviceMiorNumber;
}

inline Tint TFileProperty::GetInodeNumber() const
{
  return theInodeNumber;
}

inline Tint TFileProperty::GetProtection() const
{
  return theProtection;
}

inline Tint TFileProperty::GetNumberOfHardLinks() const
{
  return theNumberOfHardLinks;
}

inline Tint TFileProperty::GetDeviceType() const
{
  return theDeviceType;
}

inline Tint TFileProperty::GetTotalSize() const
{
  return theTotalSize;
}

inline Tint TFileProperty::GetBlockSize() const
{
  return theBlockSize;
}

inline Tint TFileProperty::GetNumberOfBlocks() const
{
  return theNumberOfBlocks;
}

inline Tint TFileProperty::GetUserID() const
{
  return theUserID;
}

inline Tint TFileProperty::GetGroupID() const
{
  return theGroupID;
}

inline Tint TFileProperty::GetLastAccess() const
{
  return theLastAccess;
}

inline Tint TFileProperty::GetLastModification() const
{
  return theLastModification;
}

inline Tint TFileProperty::GetLastChange() const
{
  return theLastChange;
}

inline const Tstring& TFileProperty::GetStringUserID() const
{
  return theStringUserID;
}

inline const Tstring& TFileProperty::GetStringGroupID() const
{
  return theStringGroupID;
}

inline const Tstring& TFileProperty::GetStringLastAccess() const
{
  return theStringLastAccess;
}

inline const Tstring& TFileProperty::GetStringLastModification() const
{
  return theStringLastModification;
}

inline const Tstring& TFileProperty::GetStringLastChange() const
{
  return theStringLastChange;
}

inline Tvoid TFileProperty::SetPathName( const Tstring& path )
{
  thePathName = path;
  Analyse();
  return;
}

inline Tvoid TFileProperty::Update()
{
  Analyse();
  return;
}

#endif
