// =====================================================================
//  $Id: Bt00CrateDefinition.cc,v 1.3 2003/10/06 16:28:14 goiwai Exp $
//  $Name: CLDAQ-1-13-00 $
//  $Log: Bt00CrateDefinition.cc,v $
//  Revision 1.3  2003/10/06 16:28:14  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:13:49  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TCrate.hh"
#include "TRunManager.hh"
#include "TSoftwareScalerModule.hh"
#include "TSoftwareTimerModule.hh"
#include "TSoftwareClockModule.hh"
#include "TSoftwareRunInformationModule.hh"
#include "TRunInformationTable.hh"
#include "TCamacCrateController.hh"
#include "TCamacAdcModule.hh"
#include "TCamacScalerModule.hh"
#include "TCamacInterruptRegisterModule.hh"
#include "TCamacOutputRegisterModule.hh"
#include "TCamacCoincidenceRegisterModule.hh"
#include "TRunInformationList.hh"
#include "TRunInformation.hh"

#include "Bt00CrateDefinition.hh"

Bt00CrateDefinition::Bt00CrateDefinition()
  : TCrateDefinition()
{;}

Bt00CrateDefinition::~Bt00CrateDefinition()
{;}

TCrate* Bt00CrateDefinition::Define()
{
  TRunInformationList infolist;
  infolist.push_back( TRunInformation( "OPERATOR", tInfoFreeValue ) );
  TstringList selectlist;
  selectlist.push_back( "80.0 MeV" );
  selectlist.push_back( "90.0 MeV" );
  selectlist.push_back( "100.0 MeV" );
  selectlist.push_back( "110.0 MeV" );
  selectlist.push_back( "120.0 MeV" );
  selectlist.push_back( "130.0 MeV" );
  selectlist.push_back( "140.0 MeV" );
  selectlist.push_back( "150.0 MeV" );
  selectlist.push_back( "160.0 MeV" );
  selectlist.push_back( "170.0 MeV" );
  selectlist.push_back( "180.0 MeV" );
  selectlist.push_back( "190.0 MeV" );
  selectlist.push_back( "200.0 MeV" );
  infolist.push_back( TRunInformation( "BEAM ENERGY", selectlist ) );
  selectlist.clear();
  selectlist.push_back( "REAL RUN" );
  selectlist.push_back( "TEST RUN" );
  infolist.push_back( TRunInformation( "RUN TYPE", selectlist ) );
  infolist.push_back( TRunInformation( "COMMENT", tInfoFreeText ) );
  TRunInformationTable table( infolist );

  TCrate* crate = new TCrate();

  // CC7700
  TCamacCrateController* cc7700 = new TCamacCrateController( tPCIcc7700_1 );
  cc7700 -> SetCrateID( 0 );
  cc7700 -> Initialize();
  TstringList groups;
  groups.push_back( "run begin" );
  crate -> InstallModule( cc7700, "CC7700", groups );

  // CAMAC module
  const Tint adcslot = 1;
  TCamacAdcModule* adc = new TCamacAdcModule( cc7700, adcslot, 1 );
  groups.clear();
  groups.push_back( "run begin" );
  groups.push_back( "csi event" );
  crate -> InstallModule( adc, "ADC", groups );

  const Tint scalerslot = 7;
  TCamacScalerModule* scaler = new TCamacScalerModule( cc7700, scalerslot, 8 );
  groups.clear();
  groups.push_back( "run begin" );
  groups.push_back( "scaler event" );
  crate -> InstallModule( scaler, "Scaler", groups );

  const Tint orslot = 21;
  TCamacOutputRegisterModule* org = new TCamacOutputRegisterModule( cc7700, orslot );
  groups.clear();
  groups.push_back( "run begin" );
  crate -> InstallModule( org, "Output Register", groups );

  const Tint crslot = 13;
  TCamacCoincidenceRegisterModule* cr = new TCamacCoincidenceRegisterModule( cc7700, crslot );
  groups.clear();
  groups.push_back( "run begin" );
  groups.push_back( "csi event" );
  crate -> InstallModule( cr, "Coincidence Register", groups );

  const Tint irslot = 22;
  TCamacInterruptRegisterModule* ir = new TCamacInterruptRegisterModule( cc7700, irslot );
  groups.clear();
  groups.push_back( "run begin" );
  groups.push_back( "csi event" );
  groups.push_back( "scaler event" );
  crate -> InstallModule( ir, "Interrupt Register", groups );


  // software module
  TSoftwareRunInformationModule* runinfo = new TSoftwareRunInformationModule( table );
  crate -> InstallModule( runinfo, "Run Information" );
  TRunManager::GetRunManager() -> SetRunInformationModule( runinfo );


  TSoftwareTimerModule* timer = new TSoftwareTimerModule( Tusec, 1 );
  groups.clear();
  groups.push_back( "run begin" );
  crate -> InstallModule( timer, "Timer", groups );

  TSoftwareClockModule* clock = new TSoftwareClockModule( 1 );
  groups.clear();
  groups.push_back( "run begin" );
  crate -> InstallModule( clock, "Clock", groups );

  TSoftwareScalerModule* runnumber = new TSoftwareScalerModule( 1 );
  groups.clear();
  groups.push_back( "run begin" );
  crate -> InstallModule( runnumber, "Run ID", groups );

  TSoftwareScalerModule* evtnumber = new TSoftwareScalerModule( 1 );
  groups.clear();
  groups.push_back( "run begin" );
  groups.push_back( "csi event" );
  groups.push_back( "scaler event" );
  crate -> InstallModule( evtnumber, "Event ID", groups );

  return crate;
}
