// =====================================================================
//  $Id: st02.cc,v 1.3 2003/10/06 16:28:19 goiwai Exp $
//  $Name: CLDAQ-1-13-00 $
//  $Log: st02.cc,v $
//  Revision 1.3  2003/10/06 16:28:19  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:16:35  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TRunManager.hh"
#include "TEventManager.hh"
#include "TTerminalUserInterface.hh"
#include "TCrate.hh"

#include "St02RunAction.hh"
#include "St02EventAction.hh"
#include "St02CrateDefinition.hh"
#include "St02ReadoutBookDefinition.hh"
#include "St02DarkViewCommand.hh"
#include "St02SignalViewCommand.hh"

static const Tstring _rcpath = "st02setup";

int main( int argc, char** argv, char** envv )
{
  TRunManager* manager = new TRunManager( new TTerminalUserInterface() );
  manager -> GetEventManager() -> SetStackSize( 0 );

  manager -> GetEnvironmentVariableTable().SetEnvironment( _rcpath );
  manager -> SetRunAction( new St02RunAction() );
  manager -> SetEventAction( new St02EventAction() );
  manager -> SetCrateDefinition( new St02CrateDefinition() );
  manager -> SetReadoutBookDefinition( new St02ReadoutBookDefinition() );

  manager -> SetUserCommand( new St02DarkViewCommand() );
  manager -> SetUserCommand( new St02SignalViewCommand() );

  manager -> SessionStart();

  delete manager;

  return 0;
}
