// =====================================================================
/*!
//
//  \file TCommandTable.hh
//  \brief This file contains the TCommandTable class.
//  \author Go IWAI <goiwai@users.sourceforge.jp>
//
//  $Id: TCommandTable.hh,v 1.6 2004/03/07 10:30:28 goiwai Exp $
//  $Name: CLDAQ-1-13-00 $
//  $Log: TCommandTable.hh,v $
//  Revision 1.6  2004/03/07 10:30:28  goiwai
//  ROOTȤߤिΤޤʤޥᤳߤޤ
//  Ƥˤƴư櫓ǤϤޤ
//
//  Revision 1.5  2004/01/19 21:09:38  goiwai
//  ץץåƬCLDAQ__ѹޤ.
//
//  Revision 1.4  2003/11/03 08:35:11  goiwai
//  DoxygenѤΥȥȤ򤦤Ǥߤ򳫻Ϥޤ.
//
//  Revision 1.3  2003/10/06 17:02:37  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:17:31  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
*/
// =====================================================================
#ifndef CLDAQ__TCOMMANDTABLE_HH
#define CLDAQ__TCOMMANDTABLE_HH

#include "Tglobals.h"
#include "TCommandSpecified.hh"


/*!
// \example
//
// If example code exists.
//
*/

/*!
// \class TCommandTable
// \brief This is the TCommandTable class.
// \author Go IWAI <goiwai@users.sourceforge.jp>
//
// The TCommandTable class detail description.
// Write it down ASAP!
//
// \todo None?
// \bug None?
// \ingroup CommandsCategory
*/
class TCommandTable
  : public Tvector<TCommandSpecified>
{

  public:
    TCommandTable();
    ~TCommandTable();

  public:
    TCommand* FindCommand( const Tstring& fullname ) const;
    TCommand* FindCommand( const Tstring& name, const Tstring& path ) const;
    Tbool AlreadyExist( TCommand* command ) const;
    Tbool AlreadyExist( const Tstring& fullname ) const;
    Tbool AlreadyExist( const Tstring& name, const Tstring& path ) const;
    Tbool AlreadyExistDirectory( const Tstring& path ) const;
    Tbool AlreadyExistDirectory( const Tstring& name, const Tstring& path ) const;
    Tvoid AddCommand( TCommand* command );
    Tvoid RemoveCommand( Tint index );
    Tint GetSize() const;
    Tvoid Clear();
    TstringList GetDirectoryList( const Tstring& path = "/" ) const;
    TstringList GetCommandList( const Tstring& path = "/" ) const;
    TstringList Sort( const Tstring& path = "/" ) const;
    TstringList Sort( const TstringList& sort ) const;
    Tvoid List( Tint column, const TstringList& strlist ) const;
    Tvoid List( Tint column, const Tstring& path = "/" ) const;
    TCommandSpecified GetCommandSpecified( Tint index ) const;
    TCommandSpecified GetCommandSpecified( const Tstring& fullname ) const;

  private:
    TCommandSpecified convert( TCommand* command ) const;

#ifdef __CLDAQ_ROOT_DLL
    ClassDef(TCommandTable,0)
#endif

};

#endif
