// =====================================================================
/*!
//
//  \file TDateCommand.hh
//  \brief This file contains the TDateCommand class.
//  \author Go IWAI <goiwai@users.sourceforge.jp>
//
//  $Id: TDateCommand.hh,v 1.6 2004/03/07 10:30:28 goiwai Exp $
//  $Name: CLDAQ-1-13-00 $
//  $Log: TDateCommand.hh,v $
//  Revision 1.6  2004/03/07 10:30:28  goiwai
//  ROOTȤߤिΤޤʤޥᤳߤޤ
//  Ƥˤƴư櫓ǤϤޤ
//
//  Revision 1.5  2004/01/19 21:09:38  goiwai
//  ץץåƬCLDAQ__ѹޤ.
//
//  Revision 1.4  2003/11/03 08:35:11  goiwai
//  DoxygenѤΥȥȤ򤦤Ǥߤ򳫻Ϥޤ.
//
//  Revision 1.3  2003/10/06 17:02:37  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:17:31  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
*/
// =====================================================================
#ifndef CLDAQ__TDATECOMMAND_HH
#define CLDAQ__TDATECOMMAND_HH

#include "Tglobals.h"
#include "TCommand.hh"
#include "TSystemClock.hh"

class TRunManager;
class TSystemClock;


/*!
// \example
//
// If example code exists.
//
*/

/*!
// \class TDateCommand
// \brief This is the TDateCommand class.
// \author Go IWAI <goiwai@users.sourceforge.jp>
//
// The TDateCommand class detail description.
// Write it down ASAP!
//
// \todo None?
// \bug None?
// \ingroup CommandsCategory
*/
class TDateCommand
  : public TCommand
{

  private:
    TSystemClock theSystemClock;

  public:
    TDateCommand( TRunManager* manager );
    ~TDateCommand();

  public:
    Tvoid Execute( const TstringList& arguments );

  public:
    const TSystemClock& GetSystemClock() const;
    Tvoid SetSystemClock( const TSystemClock& clock );

#ifdef __CLDAQ_ROOT_DLL
    ClassDef(TDateCommand,0)
#endif

};

inline const TSystemClock& TDateCommand::GetSystemClock() const
{
  return theSystemClock;
}

inline Tvoid TDateCommand::SetSystemClock( const TSystemClock& clock )
{
  theSystemClock = clock;
  return;
}

#endif
