// =====================================================================
//  $Id: TSoftwareClockModule.cc,v 1.5 2004/03/07 10:30:31 goiwai Exp $
//  $Name: CLDAQ-1-13-00 $
//  $Log: TSoftwareClockModule.cc,v $
//  Revision 1.5  2004/03/07 10:30:31  goiwai
//  ROOTȤߤिΤޤʤޥᤳߤޤ
//  Ƥˤƴư櫓ǤϤޤ
//
//  Revision 1.4  2003/10/06 17:02:40  goiwai
//  *** empty log message ***
//
//  Revision 1.3  2003/07/30 16:19:11  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TSoftwareClockModule.hh"
#include "TDataSegment.hh"
#include "TDataElement.hh"

TSoftwareClockModule::TSoftwareClockModule( Tint nchannel )
  : TSoftwareModule( nchannel ), theSystemClock()
{;}

TSoftwareClockModule::TSoftwareClockModule( const TSoftwareClockModule& right )
  : TSoftwareModule( right ), 
    theSystemClock( right.theSystemClock )
{;}

TSoftwareClockModule::~TSoftwareClockModule()
{;}

Tint TSoftwareClockModule::Clear()
{
  return theStatus = tStatusSuccess;
}

Tint TSoftwareClockModule::Update()
{
  theSystemClock.Update();
  return theStatus = tStatusSuccess;
}

Tint TSoftwareClockModule::Initialize()
{
  theSystemClock = TSystemClock( theSystemClock );
  return theStatus = tStatusSuccess;
}

Tvoid TSoftwareClockModule::FillData( TDataElement& element, Tint channel )
{
  if ( channel < 0 || channel >= theNumberOfChannels ) {
    theStatus = -EFAULT;
    Tcerr << "TSoftwareClockModule::FillData: invalid ID " << channel << Tendl;
    element.FillData( &theStatus, tTypeInt, 1 );
  } else {
    Tint intbuf;
    Tstring strbuf;
    switch( channel ) {
      case tIntegerTime:
        intbuf = GetIntegerTime();
        element.FillData( &intbuf, tTypeInt, 1 );
        break;
      case tElapsedTimeOfLastInitialize:
        intbuf = GetElapsedTimeOfLastInitialize();
        element.FillData( &intbuf, tTypeInt, 1 );
        break;
      case tElapsedTimeOfLastUpdate:
        intbuf = GetElapsedTimeOfLastUpdate();
        element.FillData( &intbuf, tTypeInt, 1 );
        break;
      case tYear:
        intbuf = GetYear();
        element.FillData( &intbuf, tTypeInt, 1 );
        break;
      case tMonth:
        intbuf = GetMonth();
        element.FillData( &intbuf, tTypeInt, 1 );
        break;
      case tDay:
        intbuf = GetDay();
        element.FillData( &intbuf, tTypeInt, 1 );
        break;
      case tHour:
        intbuf = GetHour();
        element.FillData( &intbuf, tTypeInt, 1 );
        break;
      case tMinute:
        intbuf = GetMinute();
        element.FillData( &intbuf, tTypeInt, 1 );
        break;
      case tSecond:
        intbuf = GetSecond();
        element.FillData( &intbuf, tTypeInt, 1 );
        break;
      case tStringTime:
      default:
        strbuf = WhatTimeIsItNow();
        element.FillData( &strbuf, tTypeString, 1 );
        break;
    }
  }
  return;
}

const TSoftwareClockModule& TSoftwareClockModule::operator=( const TSoftwareClockModule& right )
{
  *( (TSoftwareModule*)this ) = *( (TSoftwareModule*)(&right) );
  theSystemClock = right.theSystemClock;
  return *this;
}

Tbool TSoftwareClockModule::operator==( const TSoftwareClockModule& right ) const
{
  Tbool retval = Ttrue;
  retval &= ( *( (TSoftwareModule*)this ) == *( (TSoftwareModule*)(&right) ) );
  retval &= ( theSystemClock.GetAllocatedTime() == right.theSystemClock.GetAllocatedTime() );
  return retval;
}

Tbool TSoftwareClockModule::operator!=( const TSoftwareClockModule& right ) const
{
  Tbool retval = Tfalse;
  retval |= ( *( (TSoftwareModule*)this ) != *( (TSoftwareModule*)(&right) ) );
  retval |= ( theSystemClock.GetAllocatedTime() != right.theSystemClock.GetAllocatedTime() );
  return retval;
}

#ifdef __CLDAQ_ROOT_DLL
    ClassImp(TSoftwareClockModule)
#endif
