// =====================================================================
//  $Id: TReadoutList.cc,v 1.4 2004/03/07 10:30:33 goiwai Exp $
//  $Name: CLDAQ-1-13-00 $
//  $Log: TReadoutList.cc,v $
//  Revision 1.4  2004/03/07 10:30:33  goiwai
//  ROOTȤߤिΤޤʤޥᤳߤޤ
//  Ƥˤƴư櫓ǤϤޤ
//
//  Revision 1.3  2003/10/06 16:39:00  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:20:11  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TReadoutList.hh"
#include "TDataRecord.hh"

TReadoutList::TReadoutList( const Tstring& id )
  : TReadoutIdentification( id ), TReadoutSectionList()
{;}

TReadoutList::TReadoutList( const TReadoutList& right )
  : TReadoutIdentification( right ), TReadoutSectionList( right )
{;}

TReadoutList::~TReadoutList()
{;}

TDataRecord TReadoutList::Read()
{
  TDataRecord record( theID );

  for ( Tsize_t i = 0; i < size(); i ++ ) {
    record.push_back( ( (*this)[ i ] ).Read() );
  }

  return record;
}

const TReadoutList& TReadoutList::operator=( const TReadoutList& right )
{
  *( (TReadoutIdentification*)this ) = *( (TReadoutIdentification*)(&right) );
  *( (TReadoutSectionList*)this ) = *( (TReadoutSectionList*)(&right) );
  return *this;
}

Tbool TReadoutList::operator==( const TReadoutList& right ) const
{
  Tbool ret = Ttrue;
  ret &= ( *( (TReadoutIdentification*)this ) == *( (TReadoutIdentification*)(&right) ) );
  ret &= ( *( (TReadoutSectionList*)this ) == *( (TReadoutSectionList*)(&right) ) );
  return ret;
}

Tbool TReadoutList::operator!=( const TReadoutList& right ) const
{
  Tbool ret = Tfalse;
  ret |= ( *( (TReadoutIdentification*)this ) != *( (TReadoutIdentification*)(&right) ) );
  ret |= ( *( (TReadoutSectionList*)this ) != *( (TReadoutSectionList*)(&right) ) );
  return ret;
}

#ifdef __CLDAQ_ROOT_DLL
    ClassImp(TReadoutList)
#endif
