// ============================================================================
/*!
//
//  \file TOptionTable.hh
//  \brief This file contains the TOptionTable class.
//  \author Go IWAI <goiwai@users.sourceforge.jp>
//
//  $Id: TOptionTable.hh,v 1.4 2004/03/07 10:30:34 goiwai Exp $
//  $Name: CLDAQ-1-13-00 $
//  $Log: TOptionTable.hh,v $
//  Revision 1.4  2004/03/07 10:30:34  goiwai
//  ROOTȤߤिΤޤʤޥᤳߤޤ
//  Ƥˤƴư櫓ǤϤޤ
//
//  Revision 1.3  2004/01/19 21:09:43  goiwai
//  ץץåƬCLDAQ__ѹޤ.
//
//  Revision 1.2  2003/11/03 08:35:15  goiwai
//  DoxygenѤΥȥȤ򤦤Ǥߤ򳫻Ϥޤ.
//
//  Revision 1.1  2003/10/06 16:32:25  goiwai
//  GNUΰñˤľŪ˲᤹뤿ʤǤ.
//
*/
// ============================================================================
#ifndef CLDAQ__TOPTIONTABLE_HH
#define CLDAQ__TOPTIONTABLE_HH

#include "Tglobals.h"
#include "TOption.hh"
#include "TOptionList.hh"


/*!
// \example
//
// If example code exists.
//
*/

/*!
// \class TOptionTable
// \brief This is the TOptionTable class.
// \author Go IWAI <goiwai@users.sourceforge.jp>
//
// The TOptionTable class detail description.
// Write it down ASAP!
//
// \todo None?
// \bug None?
// \ingroup SystemCategory
*/
class TOptionTable
{

  private:
    TOptionList theOptionList;

  public:
    TOptionTable();
    TOptionTable( const TOptionList& options );
    TOptionTable( const TOption* options, Tint noption = 1 );
    TOptionTable( const TOptionTable& right );
    ~TOptionTable();

  public:
    const TOptionTable& operator=( const TOptionTable& right );

  public:
    friend Tostream& operator<<( Tostream& tos, const TOptionTable& right );

  public:
    Tvoid SetDefaultOption();
    Tvoid SetOption( const TOption& option );

  public:
    const TOptionList& GetOptionList() const;
    TOptionList& GetOptionList();
    Tvoid SetOptionList( const TOptionList& options );

  private:
    Tvoid dupcheck() const;

#ifdef __CLDAQ_ROOT_DLL
    ClassDef(TOptionTable,0)
#endif

};

inline const TOptionList& TOptionTable::GetOptionList() const
{
  return theOptionList;
}

inline TOptionList& TOptionTable::GetOptionList()
{
  return theOptionList;
}

inline Tvoid TOptionTable::SetOptionList( const TOptionList& options )
{
  theOptionList = options;
  return;
}

#endif
