Cowboy examples
===============

 *  [chunked_hello_world](./chunked_hello_world):
    demonstrates chunked data transfer with two one-second delays

 *  [compress_response](./compress_response)
    send a response body compressed if the client supports it

 *  [cookie](./cookie):
    set cookies from server and client side

 *  [echo_get](./echo_get):
    parse and echo a GET query string

 *  [echo_post](./echo_post):
    parse and echo a POST parameter

 *  [error_hook](./error_hook):
    provide custom error pages

 *  [eventsource](./eventsource):
    eventsource emitter and consumer

 *  [hello_world](./hello_world):
    simplest example application

 *  [markdown_middleware](./markdown_middleware):
    static file handler with markdown preprocessor

 *  [rest_basic_auth](./rest_basic_auth):
    basic HTTP authorization with REST

 *  [rest_hello_world](./rest_hello_world):
    return the data type that matches the request type (ex: html, text, json)

 *  [rest_pastebin](./rest_pastebin):
    create text objects and return the data type that matches the request type (html, text)

 *  [rest_stream_response](./rest_stream_response):
    stream results from a data store

 *  [ssl_hello_world](./ssl_hello_world):
    simplest SSL application

 *  [static_world](./static_world):
    static file handler

 *  [upload](./upload):
    multipart/form-data upload

 *  [web_server](./web_server):
    serves files with lists directory entries

 *  [websocket](./websocket):
    websocket example

Other languages
---------------

 *  [elixir](https://github.com/joshrotenberg/elixir_cowboy1_examples)
